<?php
/**
 * سایدبار پنل مدیریت
 */
$currentPage = $_GET['page'] ?? 'admin';
?>
<aside id="adminSidebar" class="fixed right-0 top-0 h-full w-64 glass-dark z-50 transform translate-x-full lg:translate-x-0 transition-transform duration-300">
    <div class="flex flex-col h-full">
        <!-- لوگو -->
        <div class="p-6 border-b border-white/10">
            <a href="?page=admin" class="flex items-center gap-3">
                <div class="w-12 h-12 rounded-xl bg-gradient-to-r from-primary-500 to-secondary-500 flex items-center justify-center">
                    <svg class="w-7 h-7" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"></path>
                    </svg>
                </div>
                <div>
                    <div class="font-bold"><?php echo getSetting('site_name', 'VPN Shop'); ?></div>
                    <div class="text-xs text-gray-400">پنل مدیریت</div>
                </div>
            </a>
        </div>
        
        <!-- منوی اصلی -->
        <nav class="flex-1 overflow-y-auto p-4 space-y-1">
            <!-- داشبورد -->
            <a href="?page=admin" class="flex items-center gap-3 px-4 py-3 rounded-xl transition-all <?php echo $currentPage === 'admin' ? 'bg-primary-500/20 text-primary-400' : 'hover:bg-white/10 text-gray-300'; ?>">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 5a1 1 0 011-1h14a1 1 0 011 1v2a1 1 0 01-1 1H5a1 1 0 01-1-1V5zM4 13a1 1 0 011-1h6a1 1 0 011 1v6a1 1 0 01-1 1H5a1 1 0 01-1-1v-6zM16 13a1 1 0 011-1h2a1 1 0 011 1v6a1 1 0 01-1 1h-2a1 1 0 01-1-1v-6z"></path>
                </svg>
                <span>داشبورد</span>
            </a>
            
            <!-- مدیریت کاربران -->
            <a href="?page=admin-users" class="flex items-center gap-3 px-4 py-3 rounded-xl transition-all <?php echo $currentPage === 'admin-users' ? 'bg-primary-500/20 text-primary-400' : 'hover:bg-white/10 text-gray-300'; ?>">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0zm6 3a2 2 0 11-4 0 2 2 0 014 0zM7 10a2 2 0 11-4 0 2 2 0 014 0z"></path>
                </svg>
                <span>کاربران</span>
            </a>
            
            <!-- سفارشات -->
            <a href="?page=admin-orders" class="flex items-center gap-3 px-4 py-3 rounded-xl transition-all <?php echo $currentPage === 'admin-orders' ? 'bg-primary-500/20 text-primary-400' : 'hover:bg-white/10 text-gray-300'; ?>">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2m-3 7h3m-3 4h3m-6-4h.01M9 16h.01"></path>
                </svg>
                <span>سفارشات</span>
                <?php
                $pendingOrders = db()->fetch("SELECT COUNT(*) as c FROM orders WHERE status = 'pending'")['c'];
                if ($pendingOrders > 0):
                ?>
                    <span class="mr-auto px-2 py-0.5 rounded-full bg-yellow-500/20 text-yellow-400 text-xs"><?php echo $pendingOrders; ?></span>
                <?php endif; ?>
            </a>
            
            <!-- کانفیگ‌ها -->
            <a href="?page=admin-configs" class="flex items-center gap-3 px-4 py-3 rounded-xl transition-all <?php echo $currentPage === 'admin-configs' ? 'bg-primary-500/20 text-primary-400' : 'hover:bg-white/10 text-gray-300'; ?>">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13.828 10.172a4 4 0 00-5.656 0l-4 4a4 4 0 105.656 5.656l1.102-1.101m-.758-4.899a4 4 0 005.656 0l4-4a4 4 0 00-5.656-5.656l-1.1 1.1"></path>
                </svg>
                <span>کانفیگ‌ها</span>
            </a>
            
<!-- نوتیفیکیشن‌ها -->
<a href="?page=admin-notifications" class="flex items-center gap-3 px-4 py-3 rounded-xl transition-all <?php echo $currentPage === 'admin-notifications' ? 'bg-primary-500/20 text-primary-400' : 'hover:bg-white/10 text-gray-300'; ?>">
    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 17h5l-1.405-1.405A2.032 2.032 0 0118 14.158V11a6.002 6.002 0 00-4-5.659V5a2 2 0 10-4 0v.341C7.67 6.165 6 8.388 6 11v3.159c0 .538-.214 1.055-.595 1.436L4 17h5m6 0v1a3 3 0 11-6 0v-1m6 0H9"></path>
    </svg>
    <span>اعلان‌ها</span>
</a>

<!-- کدهای تخفیف -->
<a href="?page=admin-discounts" class="flex items-center gap-3 px-4 py-3 rounded-xl transition-all <?php echo $currentPage === 'admin-discounts' ? 'bg-primary-500/20 text-primary-400' : 'hover:bg-white/10 text-gray-300'; ?>">
    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
       <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 17h5l-1.405-1.405A2.032 2.032 0 0118 14.158V11a6.002 6.002 0 00-4-5.659V5a2 2 0 10-4 0v.341C7.67 6.165 6 8.388 6 11v3.159c0 .538-.214 1.055-.595 1.436L4 17h5m6 0v1a3 3 0 11-6 0v-1m6 0H9"></path>
    </svg>
    <span>کدهای تخفیف</span>
</a>
          <!-- پرداخت‌ها -->
            <a href="?page=admin-payments" class="flex items-center gap-3 px-4 py-3 rounded-xl transition-all <?php echo $currentPage === 'admin-payments' ? 'bg-primary-500/20 text-primary-400' : 'hover:bg-white/10 text-gray-300'; ?>">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 10h18M7 15h1m4 0h1m-7 4h12a3 3 0 003-3V8a3 3 0 00-3-3H6a3 3 0 00-3 3v8a3 3 0 003 3z"></path>
                </svg>
                <span>پرداخت‌ها</span>
                <?php
                $pendingCharges = db()->fetch("SELECT COUNT(*) as c FROM charge_requests WHERE status = 'pending'")['c'];
                if ($pendingCharges > 0):
                ?>
                    <span class="mr-auto px-2 py-0.5 rounded-full bg-green-500/20 text-green-400 text-xs"><?php echo $pendingCharges; ?></span>
                <?php endif; ?>
            </a>
            
            <!-- تیکت‌ها -->
            <a href="?page=admin-tickets" class="flex items-center gap-3 px-4 py-3 rounded-xl transition-all <?php echo $currentPage === 'admin-tickets' ? 'bg-primary-500/20 text-primary-400' : 'hover:bg-white/10 text-gray-300'; ?>">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 10h.01M12 10h.01M16 10h.01M9 16H5a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v8a2 2 0 01-2 2h-5l-5 5v-5z"></path>
                </svg>
                <span>تیکت‌ها</span>
                <?php
                $pendingTickets = db()->fetch("SELECT COUNT(*) as c FROM tickets WHERE status IN ('open', 'waiting')")['c'];
                if ($pendingTickets > 0):
                ?>
                    <span class="mr-auto px-2 py-0.5 rounded-full bg-blue-500/20 text-blue-400 text-xs"><?php echo $pendingTickets; ?></span>
                <?php endif; ?>
            </a>
            
            <!-- زیرمجموعه‌ها -->
            <a href="?page=admin-referrals" class="flex items-center gap-3 px-4 py-3 rounded-xl transition-all <?php echo $currentPage === 'admin-referrals' ? 'bg-primary-500/20 text-primary-400' : 'hover:bg-white/10 text-gray-300'; ?>">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197m13.5-9a2.5 2.5 0 11-5 0 2.5 2.5 0 015 0z"></path>
                </svg>
                <span>زیرمجموعه‌ها</span>
            </a>
            
            <div class="pt-4 mt-4 border-t border-white/10">
                <span class="px-4 text-xs text-gray-500 uppercase">تنظیمات</span>
            </div>
            
            <!-- تنظیمات -->
            <a href="?page=admin-settings" class="flex items-center gap-3 px-4 py-3 rounded-xl transition-all <?php echo $currentPage === 'admin-settings' ? 'bg-primary-500/20 text-primary-400' : 'hover:bg-white/10 text-gray-300'; ?>">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M10.325 4.317c.426-1.756 2.924-1.756 3.35 0a1.724 1.724 0 002.573 1.066c1.543-.94 3.31.826 2.37 2.37a1.724 1.724 0 001.065 2.572c1.756.426 1.756 2.924 0 3.35a1.724 1.724 0 00-1.066 2.573c.94 1.543-.826 3.31-2.37 2.37a1.724 1.724 0 00-2.572 1.065c-.426 1.756-2.924 1.756-3.35 0a1.724 1.724 0 00-2.573-1.066c-1.543.94-3.31-.826-2.37-2.37a1.724 1.724 0 00-1.065-2.572c-1.756-.426-1.756-2.924 0-3.35a1.724 1.724 0 001.066-2.573c-.94-1.543.826-3.31 2.37-2.37.996.608 2.296.07 2.572-1.065z"></path>
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                </svg>
                <span>تنظیمات</span>
            </a>
        </nav>
        
        <!-- فوتر سایدبار -->
        <div class="p-4 border-t border-white/10">
            <div class="flex items-center gap-3 mb-4">
                <div class="w-10 h-10 rounded-xl bg-gradient-to-r from-red-500 to-orange-500 flex items-center justify-center font-bold">
                    <?php echo strtoupper(substr($user['username'], 0, 1)); ?>
                </div>
                <div class="flex-1 min-w-0">
                    <div class="font-medium truncate"><?php echo htmlspecialchars($user['username']); ?></div>
                    <div class="text-xs text-gray-400">مدیر سیستم</div>
                </div>
            </div>
            
            <div class="flex gap-2">
                <a href="?page=dashboard" class="flex-1 glass rounded-lg py-2 text-center text-sm hover:bg-white/10 transition-colors">
                    پنل کاربری
                </a>
                <a href="api.php?action=logout" class="flex-1 glass rounded-lg py-2 text-center text-sm text-red-400 hover:bg-red-500/20 transition-colors">
                    خروج
                </a>
            </div>
        </div>
    </div>
</aside>

<!-- Overlay برای موبایل -->
<div id="sidebarOverlay" class="fixed inset-0 bg-black/50 z-40 lg:hidden hidden" onclick="toggleSidebar()"></div>

<script>
function toggleSidebar() {
    const sidebar = document.getElementById('adminSidebar');
    const overlay = document.getElementById('sidebarOverlay');
    
    sidebar.classList.toggle('translate-x-full');
    sidebar.classList.toggle('translate-x-0');
    overlay.classList.toggle('hidden');
}
</script>