<?php
/**
 * هدر پنل مدیریت
 */
global $user;
$stats = getAdminDashboardStats();
?>
<header class="fixed top-0 left-0 right-0 lg:right-64 z-30 glass-dark">
    <div class="px-4 lg:px-8 h-16 flex items-center justify-between">
        <!-- منوی موبایل و جستجو -->
        <div class="flex items-center gap-4">
            <button onclick="toggleSidebar()" class="lg:hidden w-10 h-10 rounded-xl bg-white/10 flex items-center justify-center hover:bg-white/20 transition-colors">
                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 6h16M4 12h16M4 18h16"></path>
                </svg>
            </button>
            
            <!-- جستجوی سریع -->
            <div class="hidden md:block relative">
                <input type="text" id="globalSearch" class="w-64 bg-white/5 border border-white/10 rounded-xl px-4 py-2 pr-10 text-sm focus:border-primary-500 outline-none" placeholder="جستجو...">
                <svg class="w-4 h-4 absolute right-3 top-1/2 -translate-y-1/2 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
                </svg>
            </div>
        </div>
        
        <!-- آیکون‌های سمت چپ -->
        <div class="flex items-center gap-3">
            <!-- آمار سریع -->
            <div class="hidden lg:flex items-center gap-4 ml-4 pl-4 border-l border-white/10">
                <div class="text-center">
                    <div class="text-xs text-gray-400">سفارش در انتظار</div>
                    <div class="font-bold text-yellow-400"><?php echo $stats['pending_orders']; ?></div>
                </div>
                <div class="text-center">
                    <div class="text-xs text-gray-400">شارژ در انتظار</div>
                    <div class="font-bold text-green-400"><?php echo $stats['pending_charges']; ?></div>
                </div>
                <div class="text-center">
                    <div class="text-xs text-gray-400">تیکت باز</div>
                    <div class="font-bold text-blue-400"><?php echo $stats['pending_tickets']; ?></div>
                </div>
            </div>
            
            <!-- نوتیفیکیشن -->
            <div class="relative">
                <button onclick="toggleAdminNotifications()" class="w-10 h-10 rounded-xl bg-white/10 flex items-center justify-center hover:bg-white/20 transition-colors relative">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 17h5l-1.405-1.405A2.032 2.032 0 0118 14.158V11a6.002 6.002 0 00-4-5.659V5a2 2 0 10-4 0v.341C7.67 6.165 6 8.388 6 11v3.159c0 .538-.214 1.055-.595 1.436L4 17h5m6 0v1a3 3 0 11-6 0v-1m6 0H9"></path>
                    </svg>
                    <?php 
                    $totalPending = $stats['pending_orders'] + $stats['pending_charges'] + $stats['pending_tickets'];
                    if ($totalPending > 0): 
                    ?>
                        <span class="absolute -top-1 -right-1 w-5 h-5 bg-red-500 rounded-full text-xs flex items-center justify-center"><?php echo $totalPending; ?></span>
                    <?php endif; ?>
                </button>
                
                <!-- پنل نوتیفیکیشن -->
                <div id="adminNotificationPanel" class="hidden absolute left-0 top-12 w-80 glass rounded-2xl shadow-xl overflow-hidden">
                    <div class="p-4 border-b border-white/10">
                        <h4 class="font-bold">اعلان‌های سیستم</h4>
                    </div>
                    <div class="max-h-80 overflow-y-auto">
                        <?php if ($stats['pending_orders'] > 0): ?>
                            <a href="?page=admin-orders" class="flex items-center gap-3 p-4 hover:bg-white/5 transition-colors">
                                <div class="w-10 h-10 rounded-xl bg-yellow-500/20 flex items-center justify-center">
                                    <svg class="w-5 h-5 text-yellow-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"></path>
                                    </svg>
                                </div>
                                <div>
                                    <div class="font-medium"><?php echo $stats['pending_orders']; ?> سفارش در انتظار تایید</div>
                                    <div class="text-xs text-gray-400">کلیک برای مشاهده</div>
                                </div>
                            </a>
                        <?php endif; ?>
                        
                        <?php if ($stats['pending_charges'] > 0): ?>
                            <a href="?page=admin-payments" class="flex items-center gap-3 p-4 hover:bg-white/5 transition-colors">
                                <div class="w-10 h-10 rounded-xl bg-green-500/20 flex items-center justify-center">
                                    <svg class="w-5 h-5 text-green-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                    </svg>
                                </div>
                                <div>
                                    <div class="font-medium"><?php echo $stats['pending_charges']; ?> درخواست شارژ</div>
                                    <div class="text-xs text-gray-400">کلیک برای مشاهده</div>
                                </div>
                            </a>
                        <?php endif; ?>
                        
                        <?php if ($stats['pending_tickets'] > 0): ?>
                            <a href="?page=admin-tickets" class="flex items-center gap-3 p-4 hover:bg-white/5 transition-colors">
                                <div class="w-10 h-10 rounded-xl bg-blue-500/20 flex items-center justify-center">
                                    <svg class="w-5 h-5 text-blue-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 10h.01M12 10h.01M16 10h.01M9 16H5a2 2 0 01-2-2V6a2 2 0 012-2h14a2 2 0 012 2v8a2 2 0 01-2 2h-5l-5 5v-5z"></path>
                                    </svg>
                                </div>
                                <div>
                                    <div class="font-medium"><?php echo $stats['pending_tickets']; ?> تیکت باز</div>
                                    <div class="text-xs text-gray-400">کلیک برای مشاهده</div>
                                </div>
                            </a>
                        <?php endif; ?>
                        
                        <?php if ($totalPending === 0): ?>
                            <div class="p-8 text-center text-gray-400">
                                <svg class="w-12 h-12 mx-auto mb-2 opacity-50" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                                </svg>
                                <p>همه چیز تحت کنترل است!</p>
                            </div>
                        <?php endif; ?>
                    </div>
                </div>
            </div>
            
            <!-- تم -->
            <button onclick="toggleTheme()" class="w-10 h-10 rounded-xl bg-white/10 flex items-center justify-center hover:bg-white/20 transition-colors">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M20.354 15.354A9 9 0 018.646 3.646 9.003 9.003 0 0012 21a9.003 9.003 0 008.354-5.646z"></path>
                </svg>
            </button>
            
            <!-- رفرش -->
            <button onclick="location.reload()" class="w-10 h-10 rounded-xl bg-white/10 flex items-center justify-center hover:bg-white/20 transition-colors">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"></path>
                </svg>
            </button>
        </div>
    </div>
</header>

<script>
function toggleAdminNotifications() {
    const panel = document.getElementById('adminNotificationPanel');
    panel.classList.toggle('hidden');
}

// بستن با کلیک بیرون
document.addEventListener('click', function(e) {
    if (!e.target.closest('#adminNotificationPanel') && !e.target.closest('button[onclick="toggleAdminNotifications()"]')) {
        document.getElementById('adminNotificationPanel')?.classList.add('hidden');
    }
});
</script>