<?php
/**
 * صفحه آموزش و دانلود
 */
function renderUserTutorials() {
?>
<main class="pb-20 lg:pb-8 pt-16 min-h-screen">
    <div class="p-4 lg:p-8 max-w-4xl mx-auto">
        <!-- هدر -->
        <div class="mb-6">
            <h1 class="text-2xl font-bold">آموزش و دانلود</h1>
            <p class="text-gray-400 mt-1">راهنمای استفاده و دانلود اپلیکیشن‌ها</p>
        </div>

        <!-- تب‌ها -->
        <div class="flex items-center gap-2 mb-6">
            <button onclick="showTutorialTab('apps')" class="tutorial-tab active px-6 py-2.5 rounded-xl bg-primary-500 text-white font-medium" data-tab="apps">
                دانلود اپلیکیشن
            </button>
            <button onclick="showTutorialTab('tutorials')" class="tutorial-tab px-6 py-2.5 rounded-xl glass hover:bg-white/10 font-medium" data-tab="tutorials">
                آموزش‌ها
            </button>
        </div>

        <!-- دانلود اپلیکیشن‌ها -->
        <div id="appsTab" class="tutorial-content">
            <div class="grid grid-cols-1 md:grid-cols-2 gap-4">
                <!-- Android -->
                <div class="glass rounded-2xl p-6">
                    <div class="flex items-center gap-4 mb-4">
                        <div class="w-16 h-16 rounded-2xl bg-gradient-to-r from-green-500 to-emerald-500 flex items-center justify-center">
                            <svg class="w-10 h-10" viewBox="0 0 24 24" fill="currentColor">
                                <path d="M17.523 15.34c-.5 0-.914-.362-.988-.836l-.014-.164V9.66c0-.5.362-.914.836-.988l.166-.012h.674c.5 0 .914.362.988.836l.012.164v4.68c0 .5-.362.914-.836.988l-.164.012h-.674zm-11.046 0c-.5 0-.914-.362-.988-.836l-.012-.164V9.66c0-.5.362-.914.836-.988l.164-.012h.674c.5 0 .914.362.988.836l.012.164v4.68c0 .5-.362.914-.836.988l-.164.012h-.674zM15 18.5H9v.75c0 .966.784 1.75 1.75 1.75h2.5c.966 0 1.75-.784 1.75-1.75v-.75zM12 2a6.49 6.49 0 00-5.5 3.03V5a1.5 1.5 0 00-3 0v1.055a6.5 6.5 0 00.55 2.595L3 9a1 1 0 00-1 1v7a1 1 0 001 1h1.05c.232.922.684 1.754 1.3 2.436A3.75 3.75 0 008.25 23h7.5a3.75 3.75 0 003.9-2.564c.616-.682 1.068-1.514 1.3-2.436H22a1 1 0 001-1v-7a1 1 0 00-1-1l-1.05-.35a6.5 6.5 0 00.55-2.595V5a1.5 1.5 0 00-3 0v.03A6.49 6.49 0 0012 2z"/>
                            </svg>
                        </div>
                        <div>
                            <h3 class="text-xl font-bold">اندروید</h3>
                            <p class="text-gray-400">V2rayNG, Nekobox</p>
                        </div>
                    </div>
                    <div class="space-y-2">
                        <a href="#" class="flex items-center justify-between p-3 bg-white/5 rounded-xl hover:bg-white/10 transition-colors">
                            <span>V2rayNG</span>
                            <span class="text-primary-400">دانلود</span>
                        </a>
                        <a href="#" class="flex items-center justify-between p-3 bg-white/5 rounded-xl hover:bg-white/10 transition-colors">
                            <span>Nekobox</span>
                            <span class="text-primary-400">دانلود</span>
                        </a>
                        <a href="#" class="flex items-center justify-between p-3 bg-white/5 rounded-xl hover:bg-white/10 transition-colors">
                            <span>Clash for Android</span>
                            <span class="text-primary-400">دانلود</span>
                        </a>
                    </div>
                </div>

                <!-- iOS -->
                <div class="glass rounded-2xl p-6">
                    <div class="flex items-center gap-4 mb-4">
                        <div class="w-16 h-16 rounded-2xl bg-gradient-to-r from-blue-500 to-cyan-500 flex items-center justify-center">
                            <svg class="w-10 h-10" viewBox="0 0 24 24" fill="currentColor">
                                <path d="M18.71 19.5c-.83 1.24-1.71 2.45-3.05 2.47-1.34.03-1.77-.79-3.29-.79-1.53 0-2 .77-3.27.82-1.31.05-2.3-1.32-3.14-2.53C4.25 17 2.94 12.45 4.7 9.39c.87-1.52 2.43-2.48 4.12-2.51 1.28-.02 2.5.87 3.29.87.78 0 2.26-1.07 3.81-.91.65.03 2.47.26 3.64 1.98-.09.06-2.17 1.28-2.15 3.81.03 3.02 2.65 4.03 2.68 4.04-.03.07-.42 1.44-1.38 2.83M13 3.5c.73-.83 1.94-1.46 2.94-1.5.13 1.17-.34 2.35-1.04 3.19-.69.85-1.83 1.51-2.95 1.42-.15-1.15.41-2.35 1.05-3.11z"/>
                            </svg>
                        </div>
                        <div>
                            <h3 class="text-xl font-bold">آیفون (iOS)</h3>
                            <p class="text-gray-400">Shadowrocket, Streisand</p>
                        </div>
                    </div>
                    <div class="space-y-2">
                        <a href="#" class="flex items-center justify-between p-3 bg-white/5 rounded-xl hover:bg-white/10 transition-colors">
                            <span>Shadowrocket</span>
                            <span class="text-primary-400">App Store</span>
                        </a>
                        <a href="#" class="flex items-center justify-between p-3 bg-white/5 rounded-xl hover:bg-white/10 transition-colors">
                            <span>Streisand</span>
                            <span class="text-primary-400">App Store</span>
                        </a>
                        <a href="#" class="flex items-center justify-between p-3 bg-white/5 rounded-xl hover:bg-white/10 transition-colors">
                            <span>V2Box</span>
                            <span class="text-primary-400">App Store</span>
                        </a>
                    </div>
                </div>

                <!-- Windows -->
                <div class="glass rounded-2xl p-6">
                    <div class="flex items-center gap-4 mb-4">
                        <div class="w-16 h-16 rounded-2xl bg-gradient-to-r from-blue-600 to-blue-400 flex items-center justify-center">
                            <svg class="w-10 h-10" viewBox="0 0 24 24" fill="currentColor">
                                <path d="M3 12V6.75l6-1.32v6.48L3 12zm17-9v8.75l-10 .15V5.21L20 3zM3 13l6 .09v6.81l-6-1.15V13zm17 .25V22l-10-1.91V13.1l10 .15z"/>
                            </svg>
                        </div>
                        <div>
                            <h3 class="text-xl font-bold">ویندوز</h3>
                            <p class="text-gray-400">V2rayN, Nekoray</p>
                        </div>
                    </div>
                    <div class="space-y-2">
                        <a href="#" class="flex items-center justify-between p-3 bg-white/5 rounded-xl hover:bg-white/10 transition-colors">
                            <span>V2rayN</span>
                            <span class="text-primary-400">دانلود</span>
                        </a>
                        <a href="#" class="flex items-center justify-between p-3 bg-white/5 rounded-xl hover:bg-white/10 transition-colors">
                            <span>Nekoray</span>
                            <span class="text-primary-400">دانلود</span>
                        </a>
                        <a href="#" class="flex items-center justify-between p-3 bg-white/5 rounded-xl hover:bg-white/10 transition-colors">
                            <span>Clash Verge</span>
                            <span class="text-primary-400">دانلود</span>
                        </a>
                    </div>
                </div>

                <!-- macOS -->
                <div class="glass rounded-2xl p-6">
                    <div class="flex items-center gap-4 mb-4">
                        <div class="w-16 h-16 rounded-2xl bg-gradient-to-r from-gray-600 to-gray-400 flex items-center justify-center">
                            <svg class="w-10 h-10" viewBox="0 0 24 24" fill="currentColor">
                                <path d="M18.71 19.5c-.83 1.24-1.71 2.45-3.05 2.47-1.34.03-1.77-.79-3.29-.79-1.53 0-2 .77-3.27.82-1.31.05-2.3-1.32-3.14-2.53C4.25 17 2.94 12.45 4.7 9.39c.87-1.52 2.43-2.48 4.12-2.51 1.28-.02 2.5.87 3.29.87.78 0 2.26-1.07 3.81-.91.65.03 2.47.26 3.64 1.98-.09.06-2.17 1.28-2.15 3.81.03 3.02 2.65 4.03 2.68 4.04-.03.07-.42 1.44-1.38 2.83M13 3.5c.73-.83 1.94-1.46 2.94-1.5.13 1.17-.34 2.35-1.04 3.19-.69.85-1.83 1.51-2.95 1.42-.15-1.15.41-2.35 1.05-3.11z"/>
                            </svg>
                        </div>
                        <div>
                            <h3 class="text-xl font-bold">مک (macOS)</h3>
                            <p class="text-gray-400">V2rayU, ClashX</p>
                        </div>
                    </div>
                    <div class="space-y-2">
                        <a href="#" class="flex items-center justify-between p-3 bg-white/5 rounded-xl hover:bg-white/10 transition-colors">
                            <span>V2rayU</span>
                            <span class="text-primary-400">دانلود</span>
                        </a>
                        <a href="#" class="flex items-center justify-between p-3 bg-white/5 rounded-xl hover:bg-white/10 transition-colors">
                            <span>ClashX Pro</span>
                            <span class="text-primary-400">دانلود</span>
                        </a>
                    </div>
                </div>
            </div>
        </div>

        <!-- آموزش‌ها -->
        <div id="tutorialsTab" class="tutorial-content hidden">
            <div class="space-y-4">
                <!-- آموزش اندروید -->
                <div class="glass rounded-2xl overflow-hidden">
                    <button class="w-full p-4 flex items-center justify-between text-right" onclick="toggleAccordion('android-tutorial')">
                        <div class="flex items-center gap-3">
                            <div class="w-10 h-10 rounded-xl bg-green-500/20 flex items-center justify-center">
                                📱
                            </div>
                            <div>
                                <div class="font-medium">آموزش V2rayNG (اندروید)</div>
                                <div class="text-sm text-gray-400">نصب و راه‌اندازی روی گوشی اندروید</div>
                            </div>
                        </div>
                        <svg class="w-5 h-5 transform transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24" id="android-tutorial-icon">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                        </svg>
                    </button>
                    <div class="hidden p-4 pt-0 space-y-3" id="android-tutorial">
                        <div class="bg-white/5 rounded-xl p-4">
                            <div class="flex items-start gap-3">
                                <span class="w-6 h-6 rounded-full bg-primary-500 flex items-center justify-center text-sm font-bold shrink-0">1</span>
                                <div>
                                    <p class="font-medium">نصب اپلیکیشن V2rayNG</p>
                                    <p class="text-sm text-gray-400 mt-1">اپلیکیشن را از لینک بالا دانلود و نصب کنید.</p>
                                </div>
                            </div>
                        </div>
                        <div class="bg-white/5 rounded-xl p-4">
                            <div class="flex items-start gap-3">
                                <span class="w-6 h-6 rounded-full bg-primary-500 flex items-center justify-center text-sm font-bold shrink-0">2</span>
                                <div>
                                    <p class="font-medium">کپی کردن کانفیگ</p>
                                    <p class="text-sm text-gray-400 mt-1">از پنل کاربری، کانفیگ خود را کپی کنید.</p>
                                </div>
                            </div>
                        </div>
                        <div class="bg-white/5 rounded-xl p-4">
                            <div class="flex items-start gap-3">
                                <span class="w-6 h-6 rounded-full bg-primary-500 flex items-center justify-center text-sm font-bold shrink-0">3</span>
                                <div>
                                    <p class="font-medium">افزودن به اپلیکیشن</p>
                                    <p class="text-sm text-gray-400 mt-1">روی دکمه + کلیک کرده و "Import config from clipboard" را انتخاب کنید.</p>
                                </div>
                            </div>
                        </div>
                        <div class="bg-white/5 rounded-xl p-4">
                            <div class="flex items-start gap-3">
                                <span class="w-6 h-6 rounded-full bg-primary-500 flex items-center justify-center text-sm font-bold shrink-0">4</span>
                                <div>
                                    <p class="font-medium">اتصال</p>
                                    <p class="text-sm text-gray-400 mt-1">روی دکمه اتصال در پایین صفحه کلیک کنید.</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <!-- آموزش iOS -->
                <div class="glass rounded-2xl overflow-hidden">
                    <button class="w-full p-4 flex items-center justify-between text-right" onclick="toggleAccordion('ios-tutorial')">
                        <div class="flex items-center gap-3">
                            <div class="w-10 h-10 rounded-xl bg-blue-500/20 flex items-center justify-center">
                                🍎
                            </div>
                            <div>
                                <div class="font-medium">آموزش Shadowrocket (آیفون)</div>
                                <div class="text-sm text-gray-400">نصب و راه‌اندازی روی iOS</div>
                            </div>
                        </div>
                        <svg class="w-5 h-5 transform transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24" id="ios-tutorial-icon">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                        </svg>
                    </button>
                    <div class="hidden p-4 pt-0 space-y-3" id="ios-tutorial">
                        <div class="bg-white/5 rounded-xl p-4">
                            <p class="text-sm text-gray-400">برای دانلود Shadowrocket نیاز به اپل آیدی خارجی دارید. می‌توانید از پشتیبانی درخواست کنید.</p>
                        </div>
                    </div>
                </div>

                <!-- آموزش ویندوز -->
                <div class="glass rounded-2xl overflow-hidden">
                    <button class="w-full p-4 flex items-center justify-between text-right" onclick="toggleAccordion('windows-tutorial')">
                        <div class="flex items-center gap-3">
                            <div class="w-10 h-10 rounded-xl bg-blue-600/20 flex items-center justify-center">
                                💻
                            </div>
                            <div>
                                <div class="font-medium">آموزش V2rayN (ویندوز)</div>
                                <div class="text-sm text-gray-400">نصب و راه‌اندازی روی کامپیوتر</div>
                            </div>
                        </div>
                        <svg class="w-5 h-5 transform transition-transform" fill="none" stroke="currentColor" viewBox="0 0 24 24" id="windows-tutorial-icon">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 9l-7 7-7-7"></path>
                        </svg>
                    </button>
                    <div class="hidden p-4 pt-0 space-y-3" id="windows-tutorial">
                        <div class="bg-white/5 rounded-xl p-4">
                            <div class="flex items-start gap-3">
                                <span class="w-6 h-6 rounded-full bg-primary-500 flex items-center justify-center text-sm font-bold shrink-0">1</span>
                                <div>
                                    <p class="font-medium">دانلود و نصب</p>
                                    <p class="text-sm text-gray-400 mt-1">فایل zip را دانلود و در مسیر دلخواه Extract کنید.</p>
                                </div>
                            </div>
                        </div>
                        <div class="bg-white/5 rounded-xl p-4">
                            <div class="flex items-start gap-3">
                                <span class="w-6 h-6 rounded-full bg-primary-500 flex items-center justify-center text-sm font-bold shrink-0">2</span>
                                <div>
                                    <p class="font-medium">اجرای برنامه</p>
                                    <p class="text-sm text-gray-400 mt-1">فایل v2rayN.exe را اجرا کنید.</p>
                                </div>
                            </div>
                        </div>
                        <div class="bg-white/5 rounded-xl p-4">
                            <div class="flex items-start gap-3">
                                <span class="w-6 h-6 rounded-full bg-primary-500 flex items-center justify-center text-sm font-bold shrink-0">3</span>
                                <div>
                                    <p class="font-medium">افزودن کانفیگ</p>
                                    <p class="text-sm text-gray-400 mt-1">کانفیگ را کپی کرده و از منو Servers گزینه "Import from clipboard" را بزنید.</p>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
            </div>
        </div>
    </div>
</main>

<?php renderMobileNav(); ?>

<script>
function showTutorialTab(tab) {
    document.querySelectorAll('.tutorial-content').forEach(el => el.classList.add('hidden'));
    document.querySelectorAll('.tutorial-tab').forEach(el => {
        el.classList.remove('active', 'bg-primary-500', 'text-white');
        el.classList.add('glass');
    });
    
    document.getElementById(tab + 'Tab')?.classList.remove('hidden');
    const activeTab = document.querySelector(`.tutorial-tab[data-tab="${tab}"]`);
    if (activeTab) {
        activeTab.classList.add('active', 'bg-primary-500', 'text-white');
        activeTab.classList.remove('glass');
    }
}

function toggleAccordion(id) {
    const content = document.getElementById(id);
    const icon = document.getElementById(id + '-icon');
    
    if (content.classList.contains('hidden')) {
        content.classList.remove('hidden');
        icon.classList.add('rotate-180');
    } else {
        content.classList.add('hidden');
        icon.classList.remove('rotate-180');
    }
}
</script>
<?php
}
?>