<?php
/**
 * صفحه زیرمجموعه‌گیری کاربر
 */
global $user;
$referralLink = SITE_URL . '?page=register&ref=' . $user['referral_code'];
$referrals = getUserReferrals($user['id']);
$totalReward = getUserReferralReward($user['id']);
$commissionPercent = getSetting('referral_commission', 10);
?>
<main class="pb-20 lg:pb-8 pt-16 min-h-screen">
    <div class="p-4 lg:p-8 max-w-4xl mx-auto">
        <!-- هدر -->
        <div class="mb-6">
            <h1 class="text-2xl font-bold">دعوت از دوستان</h1>
            <p class="text-gray-400 mt-1">با دعوت دوستان، کمیسیون کسب کنید</p>
        </div>

        <!-- کارت لینک دعوت -->
        <div class="glass rounded-3xl p-6 mb-6 bg-gradient-to-r from-purple-500/20 to-pink-500/20">
            <div class="text-center mb-6">
                <div class="w-20 h-20 rounded-2xl bg-gradient-to-r from-purple-500 to-pink-500 flex items-center justify-center mx-auto mb-4">
                    <svg class="w-10 h-10" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 4.354a4 4 0 110 5.292M15 21H3v-1a6 6 0 0112 0v1zm0 0h6v-1a6 6 0 00-9-5.197m13.5-9a2.5 2.5 0 11-5 0 2.5 2.5 0 015 0z"></path>
                    </svg>
                </div>
                <h2 class="text-xl font-bold mb-2">کد معرف شما</h2>
                <div class="flex items-center justify-center gap-3">
                    <code class="text-3xl font-mono font-bold text-primary-400"><?php echo $user['referral_code']; ?></code>
                    <button onclick="copyCode('<?php echo $user['referral_code']; ?>')" class="w-10 h-10 rounded-xl bg-white/10 flex items-center justify-center hover:bg-white/20 transition-colors">
                        <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 5H6a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2v-1M8 5a2 2 0 002 2h2a2 2 0 002-2M8 5a2 2 0 012-2h2a2 2 0 012 2m0 0h2a2 2 0 012 2v3m2 4H10m0 0l3-3m-3 3l3 3"></path>
                        </svg>
                    </button>
                </div>
            </div>
            
            <div class="glass rounded-xl p-4 mb-4">
                <label class="block text-sm text-gray-400 mb-2">لینک دعوت</label>
                <div class="flex gap-2">
                    <input type="text" value="<?php echo $referralLink; ?>" class="flex-1 bg-white/5 border border-white/10 rounded-xl px-4 py-3 text-sm font-mono" readonly>
                    <button onclick="copyLink('<?php echo $referralLink; ?>')" class="px-4 py-3 rounded-xl bg-primary-500 hover:bg-primary-600 transition-colors">
                        کپی
                    </button>
                </div>
            </div>
            
            <div class="flex gap-2">
                <a href="https://t.me/share/url?url=<?php echo urlencode($referralLink); ?>&text=با این لینک ثبت‌نام کن!" target="_blank" class="flex-1 glass rounded-xl py-3 text-center hover:bg-blue-500/20 transition-colors">
                    <span class="flex items-center justify-center gap-2">
                        📱 اشتراک در تلگرام
                    </span>
                </a>
                <a href="https://wa.me/?text=<?php echo urlencode($referralLink); ?>" target="_blank" class="flex-1 glass rounded-xl py-3 text-center hover:bg-green-500/20 transition-colors">
                    <span class="flex items-center justify-center gap-2">
                        📲 اشتراک در واتساپ
                    </span>
                </a>
            </div>
        </div>

        <!-- آمار -->
        <div class="grid grid-cols-2 md:grid-cols-4 gap-4 mb-6">
            <div class="glass rounded-2xl p-4 text-center">
                <div class="text-3xl font-bold text-blue-400"><?php echo count($referrals); ?></div>
                <div class="text-sm text-gray-400">زیرمجموعه</div>
            </div>
            <div class="glass rounded-2xl p-4 text-center">
                <div class="text-3xl font-bold text-green-400"><?php echo number_format($totalReward); ?></div>
                <div class="text-sm text-gray-400">کل پاداش (تومان)</div>
            </div>
            <div class="glass rounded-2xl p-4 text-center">
                <div class="text-3xl font-bold text-purple-400"><?php echo $commissionPercent; ?>%</div>
                <div class="text-sm text-gray-400">درصد کمیسیون</div>
            </div>
            <div class="glass rounded-2xl p-4 text-center">
                <div class="text-3xl font-bold text-yellow-400"><?php echo number_format($user['commission_balance']); ?></div>
                <div class="text-sm text-gray-400">قابل برداشت</div>
            </div>
        </div>

        <!-- نحوه کار -->
        <div class="glass rounded-3xl p-6 mb-6">
            <h3 class="font-bold mb-4">نحوه کار سیستم رفرال</h3>
            <div class="grid grid-cols-1 md:grid-cols-3 gap-4">
                <div class="text-center p-4">
                    <div class="w-16 h-16 rounded-2xl bg-blue-500/20 flex items-center justify-center mx-auto mb-3">
                        <span class="text-3xl">1️⃣</span>
                    </div>
                    <h4 class="font-medium mb-1">اشتراک لینک</h4>
                    <p class="text-sm text-gray-400">لینک دعوت خود را برای دوستانتان ارسال کنید</p>
                </div>
                <div class="text-center p-4">
                    <div class="w-16 h-16 rounded-2xl bg-green-500/20 flex items-center justify-center mx-auto mb-3">
                        <span class="text-3xl">2️⃣</span>
                    </div>
                    <h4 class="font-medium mb-1">ثبت‌نام دوستان</h4>
                    <p class="text-sm text-gray-400">دوستان شما با کد معرف ثبت‌نام می‌کنند</p>
                </div>
                <div class="text-center p-4">
                    <div class="w-16 h-16 rounded-2xl bg-purple-500/20 flex items-center justify-center mx-auto mb-3">
                        <span class="text-3xl">3️⃣</span>
                    </div>
                    <h4 class="font-medium mb-1">دریافت کمیسیون</h4>
                    <p class="text-sm text-gray-400">از هر خرید آن‌ها <?php echo $commissionPercent; ?>% کمیسیون می‌گیرید</p>
                </div>
            </div>
        </div>

        <!-- لیست زیرمجموعه‌ها -->
        <div class="glass rounded-3xl p-6">
            <h3 class="font-bold mb-4">لیست زیرمجموعه‌ها</h3>
            
            <?php if (empty($referrals)): ?>
                <div class="text-center py-8 text-gray-400">
                    <svg class="w-16 h-16 mx-auto mb-4 opacity-50" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0z"></path>
                    </svg>
                    <p>هنوز زیرمجموعه‌ای ندارید</p>
                    <p class="text-sm mt-2">لینک دعوت خود را با دوستانتان به اشتراک بگذارید!</p>
                </div>
            <?php else: ?>
                <div class="space-y-3">
                    <?php foreach ($referrals as $ref): ?>
                        <div class="flex items-center justify-between p-3 bg-white/5 rounded-xl">
                            <div class="flex items-center gap-3">
                                <div class="w-10 h-10 rounded-xl bg-gradient-to-r from-primary-500 to-secondary-500 flex items-center justify-center font-bold">
                                    <?php echo strtoupper(substr($ref['username'], 0, 1)); ?>
                                </div>
                                <div>
                                    <div class="font-medium"><?php echo htmlspecialchars($ref['username']); ?></div>
                                    <div class="text-xs text-gray-400">عضویت: <?php echo toJalali($ref['created_at'], 'Y/m/d'); ?></div>
                                </div>
                            </div>
                        </div>
                    <?php endforeach; ?>
                </div>
            <?php endif; ?>
        </div>

        <!-- درخواست برداشت -->
        <?php if ($user['commission_balance'] >= getSetting('min_withdrawal', 50000)): ?>
            <div class="glass rounded-3xl p-6 mt-6">
                <h3 class="font-bold mb-4">درخواست برداشت</h3>
                <form id="withdrawalForm" class="space-y-4">
                    <div>
                        <label class="block text-sm text-gray-400 mb-2">مبلغ قابل برداشت</label>
                        <input type="text" value="<?php echo number_format($user['commission_balance']); ?> تومان" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3" readonly>
                    </div>
                    <div>
                        <label class="block text-sm text-gray-400 mb-2">شماره کارت</label>
                        <input type="text" name="card_number" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 focus:border-primary-500 outline-none font-mono" placeholder="0000-0000-0000-0000" required maxlength="19">
                    </div>
                    <div>
                        <label class="block text-sm text-gray-400 mb-2">نام صاحب کارت</label>
                        <input type="text" name="card_holder" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 focus:border-primary-500 outline-none" required>
                    </div>
                    <button type="submit" class="w-full bg-gradient-to-r from-green-500 to-emerald-500 rounded-xl py-3 font-medium hover:opacity-90 transition-opacity">
                        ثبت درخواست برداشت
                    </button>
                </form>
            </div>
        <?php else: ?>
            <div class="glass rounded-3xl p-6 mt-6 text-center">
                <p class="text-gray-400">حداقل مبلغ برداشت: <?php echo number_format(getSetting('min_withdrawal', 50000)); ?> تومان</p>
            </div>
        <?php endif; ?>
    </div>
</main>

<?php renderMobileNav(); ?>

<script>
function copyCode(code) {
    navigator.clipboard.writeText(code);
    showToast('کد معرف کپی شد', 'success');
}

function copyLink(link) {
    navigator.clipboard.writeText(link);
    showToast('لینک دعوت کپی شد', 'success');
}

document.getElementById('withdrawalForm')?.addEventListener('submit', async function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    formData.append('action', 'request_withdrawal');
    
    try {
        const response = await fetch('api.php', { method: 'POST', body: formData });
        const data = await response.json();
        
        if (data.success) {
            showToast('درخواست برداشت ثبت شد', 'success');
            setTimeout(() => location.reload(), 1500);
        } else {
            showToast(data.message, 'error');
        }
    } catch (error) {
        showToast('خطا در ثبت درخواست', 'error');
    }
});
</script>