<?php
/**
 * صفحه سفارشات کاربر
 */
global $user;
?>
<main class="pb-20 lg:pb-8 pt-16 min-h-screen">
    <div class="p-4 lg:p-8 max-w-4xl mx-auto">
        <!-- هدر -->
        <div class="mb-6">
            <h1 class="text-2xl font-bold">سفارشات من</h1>
            <p class="text-gray-400 mt-1">مشاهده تاریخچه سفارشات</p>
        </div>

        <!-- فیلترها -->
        <div class="flex items-center gap-3 mb-6 overflow-x-auto pb-2">
            <button onclick="filterOrders('all')" class="order-filter active px-4 py-2 rounded-xl bg-primary-500 text-white text-sm whitespace-nowrap" data-status="all">
                همه
            </button>
            <button onclick="filterOrders('pending')" class="order-filter px-4 py-2 rounded-xl glass hover:bg-white/10 text-sm whitespace-nowrap" data-status="pending">
                در انتظار
            </button>
            <button onclick="filterOrders('completed')" class="order-filter px-4 py-2 rounded-xl glass hover:bg-white/10 text-sm whitespace-nowrap" data-status="completed">
                تکمیل شده
            </button>
            <button onclick="filterOrders('rejected')" class="order-filter px-4 py-2 rounded-xl glass hover:bg-white/10 text-sm whitespace-nowrap" data-status="rejected">
                رد شده
            </button>
        </div>

        <!-- لیست سفارشات -->
        <div id="ordersList" class="space-y-4">
            <!-- سفارشات با AJAX لود می‌شوند -->
        </div>
        
        <div id="noOrders" class="hidden glass rounded-3xl p-12 text-center">
            <svg class="w-20 h-20 mx-auto mb-4 text-gray-400 opacity-50" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 5H7a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2V7a2 2 0 00-2-2h-2M9 5a2 2 0 002 2h2a2 2 0 002-2M9 5a2 2 0 012-2h2a2 2 0 012 2"></path>
            </svg>
            <h3 class="text-xl font-bold mb-2">سفارشی وجود ندارد</h3>
            <p class="text-gray-400 mb-4">هنوز سفارشی ثبت نکرده‌اید</p>
            <a href="?page=shop" class="inline-block bg-gradient-to-r from-primary-500 to-secondary-500 rounded-xl px-6 py-2.5 font-medium hover:opacity-90">
                رفتن به فروشگاه
            </a>
        </div>
    </div>
</main>

<?php renderMobileNav(); ?>

<script>
let currentFilter = 'all';

async function loadOrders() {
    try {
        const response = await fetch(`api.php?action=get_user_orders&status=${currentFilter}`);
        const data = await response.json();
        
        if (data.success) {
            renderOrders(data.orders);
        }
    } catch (error) {
        console.error('Error loading orders:', error);
    }
}

function renderOrders(orders) {
    const container = document.getElementById('ordersList');
    const noOrders = document.getElementById('noOrders');
    
    if (orders.length === 0) {
        container.innerHTML = '';
        noOrders.classList.remove('hidden');
        return;
    }
    
    noOrders.classList.add('hidden');
    container.innerHTML = orders.map(order => `
        <div class="glass rounded-2xl p-4">
            <div class="flex flex-col md:flex-row md:items-center justify-between gap-4">
                <div class="flex items-center gap-4">
                    <div class="w-12 h-12 rounded-xl bg-gradient-to-r ${getOrderGradient(order.status)} flex items-center justify-center">
                        ${getOrderIcon(order.status)}
                    </div>
                    <div>
                        <div class="font-medium">${order.product_name}</div>
                        <div class="text-sm text-gray-400">شناسه: #${order.id}</div>
                    </div>
                </div>
                <div class="flex items-center gap-4">
                    <div class="text-left">
                        <div class="font-bold">${numberFormat(order.amount)} تومان</div>
                        <div class="text-xs text-gray-400">${order.created_at}</div>
                    </div>
                    <span class="px-3 py-1 rounded-full text-xs ${getOrderStatusClass(order.status)}">
                        ${getOrderStatusText(order.status)}
                    </span>
                </div>
            </div>
            
            ${order.status === 'pending' ? `
                <div class="mt-4 p-3 bg-yellow-500/10 rounded-xl border border-yellow-500/20">
                    <div class="flex items-center gap-2 text-yellow-400 text-sm">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                        در انتظار بررسی توسط پشتیبانی
                    </div>
                </div>
            ` : ''}
            
            ${order.status === 'rejected' && order.reject_reason ? `
                <div class="mt-4 p-3 bg-red-500/10 rounded-xl border border-red-500/20">
                    <div class="text-red-400 text-sm">
                        <strong>دلیل رد:</strong> ${order.reject_reason}
                    </div>
                </div>
            ` : ''}
            
            ${order.status === 'completed' && order.config_id ? `
                <div class="mt-4 flex gap-2">
                    <button onclick="copyConfig(${order.config_id})" class="flex-1 glass rounded-xl py-2 text-sm hover:bg-white/10 transition-colors flex items-center justify-center gap-2">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M8 5H6a2 2 0 00-2 2v12a2 2 0 002 2h10a2 2 0 002-2v-1M8 5a2 2 0 002 2h2a2 2 0 002-2M8 5a2 2 0 012-2h2a2 2 0 012 2m0 0h2a2 2 0 012 2v3m2 4H10m0 0l3-3m-3 3l3 3"></path>
                        </svg>
                        کپی کانفیگ
                    </button>
                    <button onclick="showQR(${order.config_id})" class="glass rounded-xl py-2 px-4 text-sm hover:bg-white/10 transition-colors">
                        QR
                    </button>
                </div>
            ` : ''}
        </div>
    `).join('');
}

function filterOrders(status) {
    currentFilter = status;
    
    document.querySelectorAll('.order-filter').forEach(btn => {
        if (btn.dataset.status === status) {
            btn.classList.add('active', 'bg-primary-500', 'text-white');
            btn.classList.remove('glass');
        } else {
            btn.classList.remove('active', 'bg-primary-500', 'text-white');
            btn.classList.add('glass');
        }
    });
    
    loadOrders();
}

function getOrderGradient(status) {
    const gradients = {
        'pending': 'from-yellow-500 to-orange-500',
        'completed': 'from-green-500 to-emerald-500',
        'rejected': 'from-red-500 to-pink-500',
        'cancelled': 'from-gray-500 to-gray-600'
    };
    return gradients[status] || gradients['pending'];
}

function getOrderIcon(status) {
    const icons = {
        'pending': '<svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path></svg>',
        'completed': '<svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path></svg>',
        'rejected': '<svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24"><path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path></svg>'
    };
    return icons[status] || icons['pending'];
}

function getOrderStatusClass(status) {
    const classes = {
        'pending': 'bg-yellow-500/20 text-yellow-400',
        'completed': 'bg-green-500/20 text-green-400',
        'rejected': 'bg-red-500/20 text-red-400',
        'cancelled': 'bg-gray-500/20 text-gray-400'
    };
    return classes[status] || classes['pending'];
}

function getOrderStatusText(status) {
    const texts = {
        'pending': 'در انتظار',
        'completed': 'تکمیل شده',
        'rejected': 'رد شده',
        'cancelled': 'لغو شده'
    };
    return texts[status] || status;
}

async function copyConfig(configId) {
    try {
        const response = await fetch(`api.php?action=get_config_data&id=${configId}`);
        const data = await response.json();
        
        if (data.success) {
            await navigator.clipboard.writeText(data.config_data);
            showToast('کانفیگ کپی شد', 'success');
        }
    } catch (error) {
        showToast('خطا در کپی کانفیگ', 'error');
    }
}

document.addEventListener('DOMContentLoaded', loadOrders);
</script>