<?php
/**
 * صفحه ثبت‌نام
 */
$referralCode = $_GET['ref'] ?? '';
?>
<div class="min-h-screen flex items-center justify-center p-4">
    <div class="w-full max-w-md">
        <!-- لوگو -->
        <div class="text-center mb-8">
            <div class="w-20 h-20 rounded-2xl bg-gradient-to-r from-primary-500 to-secondary-500 flex items-center justify-center mx-auto mb-4">
                <svg class="w-10 h-10" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"></path>
                </svg>
            </div>
            <h1 class="text-2xl font-bold"><?php echo getSetting('site_name', 'VPN Shop'); ?></h1>
            <p class="text-gray-400 mt-2">ایجاد حساب کاربری جدید</p>
        </div>
        
        <!-- فرم ثبت‌نام -->
        <div class="glass rounded-3xl p-6">
            <form id="registerForm" class="space-y-4">
                <div>
                    <label class="block text-sm text-gray-400 mb-2">نام کاربری</label>
                    <div class="relative">
                        <input type="text" name="username" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 pr-12 focus:border-primary-500 outline-none" placeholder="username" required minlength="3">
                        <svg class="w-5 h-5 absolute right-4 top-1/2 -translate-y-1/2 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M16 7a4 4 0 11-8 0 4 4 0 018 0zM12 14a7 7 0 00-7 7h14a7 7 0 00-7-7z"></path>
                        </svg>
                    </div>
                </div>
                
                <div>
                    <label class="block text-sm text-gray-400 mb-2">شماره موبایل</label>
                    <div class="relative">
                        <input type="tel" name="phone" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 pr-12 focus:border-primary-500 outline-none" placeholder="09123456789" required pattern="09[0-9]{9}">
                        <svg class="w-5 h-5 absolute right-4 top-1/2 -translate-y-1/2 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M3 5a2 2 0 012-2h3.28a1 1 0 01.948.684l1.498 4.493a1 1 0 01-.502 1.21l-2.257 1.13a11.042 11.042 0 005.516 5.516l1.13-2.257a1 1 0 011.21-.502l4.493 1.498a1 1 0 01.684.949V19a2 2 0 01-2 2h-1C9.716 21 3 14.284 3 6V5z"></path>
                        </svg>
                    </div>
                </div>
                
                <div>
                    <label class="block text-sm text-gray-400 mb-2">رمز عبور</label>
                    <div class="relative">
                        <input type="password" name="password" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 pr-12 focus:border-primary-500 outline-none" placeholder="حداقل 6 کاراکتر" required minlength="6">
                        <svg class="w-5 h-5 absolute right-4 top-1/2 -translate-y-1/2 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 15v2m-6 4h12a2 2 0 002-2v-6a2 2 0 00-2-2H6a2 2 0 00-2 2v6a2 2 0 002 2zm10-10V7a4 4 0 00-8 0v4h8z"></path>
                        </svg>
                    </div>
                </div>
                
                <div>
                    <label class="block text-sm text-gray-400 mb-2">کد معرف (اختیاری)</label>
                    <div class="relative">
                        <input type="text" name="referral_code" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 pr-12 focus:border-primary-500 outline-none" placeholder="ABC123" value="<?php echo htmlspecialchars($referralCode); ?>">
                        <svg class="w-5 h-5 absolute right-4 top-1/2 -translate-y-1/2 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0z"></path>
                        </svg>
                    </div>
                    <?php if (getSetting('signup_bonus', 0) > 0): ?>
                        <p class="text-xs text-green-400 mt-1">🎁 با ثبت‌نام <?php echo number_format(getSetting('signup_bonus')); ?> تومان هدیه بگیرید!</p>
                    <?php endif; ?>
                </div>
                
                <label class="flex items-start gap-2 cursor-pointer">
                    <input type="checkbox" name="terms" class="rounded bg-white/10 border-white/20 text-primary-500 focus:ring-primary-500 mt-1" required>
                    <span class="text-sm text-gray-400">
                        <a href="#" class="text-primary-400 hover:underline">قوانین و مقررات</a> را مطالعه کرده و قبول دارم
                    </span>
                </label>
                
                <button type="submit" id="registerBtn" class="w-full bg-gradient-to-r from-primary-500 to-secondary-500 rounded-xl py-3 font-medium hover:opacity-90 transition-opacity">
                    ایجاد حساب کاربری
                </button>
            </form>
            
            <div class="mt-6 text-center">
                <span class="text-gray-400">حساب کاربری دارید؟</span>
                <a href="?page=login" class="text-primary-400 hover:underline mr-1">وارد شوید</a>
            </div>
        </div>
    </div>
</div>

<script>
document.getElementById('registerForm')?.addEventListener('submit', async function(e) {
    e.preventDefault();
    
    const btn = document.getElementById('registerBtn');
    const originalText = btn.textContent;
    btn.disabled = true;
    btn.innerHTML = '<div class="w-5 h-5 border-2 border-white border-t-transparent rounded-full animate-spin mx-auto"></div>';
    
    const formData = new FormData(this);
    formData.append('action', 'register');
    
    try {
        const response = await fetch('api.php', {
            method: 'POST',
            body: formData
        });
        const data = await response.json();
        
        if (data.success) {
            showToast('ثبت‌نام موفق!', 'success');
            setTimeout(() => window.location.href = data.redirect, 500);
        } else {
            showToast(data.message, 'error');
            btn.disabled = false;
            btn.textContent = originalText;
        }
    } catch (error) {
        showToast('خطا در ارتباط با سرور', 'error');
        btn.disabled = false;
        btn.textContent = originalText;
    }
});
</script>