<?php
/**
 * صفحه اصلی عمومی
 */
$features = [
    ['icon' => '⚡', 'title' => 'سرعت بالا', 'desc' => 'سرورهای پرسرعت با پینگ پایین'],
    ['icon' => '🔒', 'title' => 'امنیت کامل', 'desc' => 'رمزنگاری قوی و محافظت از حریم خصوصی'],
    ['icon' => '🌍', 'title' => 'لوکیشن متنوع', 'desc' => 'سرورهای متعدد در کشورهای مختلف'],
    ['icon' => '💬', 'title' => 'پشتیبانی ۲۴/۷', 'desc' => 'پاسخگویی سریع به سوالات شما'],
];

$locations = [
    ['flag' => '🇩🇪', 'name' => 'آلمان', 'ping' => '45ms'],
    ['flag' => '🇳🇱', 'name' => 'هلند', 'ping' => '52ms'],
    ['flag' => '🇫🇷', 'name' => 'فرانسه', 'ping' => '48ms'],
    ['flag' => '🇺🇸', 'name' => 'آمریکا', 'ping' => '120ms'],
    ['flag' => '🇬🇧', 'name' => 'انگلستان', 'ping' => '55ms'],
    ['flag' => '🇹🇷', 'name' => 'ترکیه', 'ping' => '35ms'],
];
?>

<!-- هیرو -->
<section class="min-h-screen flex items-center justify-center relative overflow-hidden">
    <!-- بکگراند افکت -->
    <div class="absolute inset-0">
        <div class="absolute top-1/4 right-1/4 w-96 h-96 bg-primary-500/20 rounded-full blur-3xl"></div>
        <div class="absolute bottom-1/4 left-1/4 w-96 h-96 bg-secondary-500/20 rounded-full blur-3xl"></div>
    </div>
    
    <div class="relative z-10 text-center p-4 max-w-4xl mx-auto">
        <div class="inline-flex items-center gap-2 px-4 py-2 rounded-full glass mb-8">
            <span class="w-2 h-2 rounded-full bg-green-400 animate-pulse"></span>
            <span class="text-sm">سرورها آنلاین هستند</span>
        </div>
        
        <h1 class="text-4xl md:text-6xl font-bold mb-6 leading-tight">
            اینترنت آزاد و امن
            <br>
            <span class="bg-gradient-to-r from-primary-400 to-secondary-400 bg-clip-text text-transparent">
                با سرعت نور!
            </span>
        </h1>
        
        <p class="text-xl text-gray-400 mb-8 max-w-2xl mx-auto">
            با کانفیگ‌های VPN حرفه‌ای ما، بدون محدودیت به تمام اینترنت دسترسی داشته باشید
        </p>
        
        <div class="flex flex-col sm:flex-row items-center justify-center gap-4">
            <a href="?page=register" class="px-8 py-4 rounded-xl bg-gradient-to-r from-primary-500 to-secondary-500 font-bold text-lg hover:opacity-90 transition-opacity flex items-center gap-2">
                شروع رایگان
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7l5 5m0 0l-5 5m5-5H6"></path>
                </svg>
            </a>
            <a href="?page=login" class="px-8 py-4 rounded-xl glass font-bold text-lg hover:bg-white/10 transition-colors">
                ورود به حساب
            </a>
        </div>
        
        <!-- آمار -->
        <div class="grid grid-cols-3 gap-8 mt-16">
            <div>
                <div class="text-3xl font-bold text-primary-400">+5000</div>
                <div class="text-gray-400">کاربر فعال</div>
            </div>
            <div>
                <div class="text-3xl font-bold text-green-400">99.9%</div>
                <div class="text-gray-400">آپتایم</div>
            </div>
            <div>
                <div class="text-3xl font-bold text-blue-400">+20</div>
                <div class="text-gray-400">لوکیشن</div>
            </div>
        </div>
    </div>
</section>

<!-- ویژگی‌ها -->
<section class="py-20 px-4">
    <div class="max-w-6xl mx-auto">
        <div class="text-center mb-12">
            <h2 class="text-3xl font-bold mb-4">چرا ما را انتخاب کنید؟</h2>
            <p class="text-gray-400">امکانات ویژه‌ای که ما ارائه می‌دهیم</p>
        </div>
        
        <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-4 gap-6">
            <?php foreach ($features as $feature): ?>
                <div class="glass rounded-2xl p-6 text-center hover:scale-105 transition-transform">
                    <div class="text-5xl mb-4"><?php echo $feature['icon']; ?></div>
                    <h3 class="text-xl font-bold mb-2"><?php echo $feature['title']; ?></h3>
                    <p class="text-gray-400"><?php echo $feature['desc']; ?></p>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>

<!-- لوکیشن‌ها -->
<section class="py-20 px-4 bg-white/5">
    <div class="max-w-6xl mx-auto">
        <div class="text-center mb-12">
            <h2 class="text-3xl font-bold mb-4">سرورهای ما</h2>
            <p class="text-gray-400">به سرورهای پرسرعت در سراسر جهان متصل شوید</p>
        </div>
        
        <div class="grid grid-cols-2 md:grid-cols-3 lg:grid-cols-6 gap-4">
            <?php foreach ($locations as $loc): ?>
                <div class="glass rounded-xl p-4 text-center">
                    <div class="text-4xl mb-2"><?php echo $loc['flag']; ?></div>
                    <div class="font-medium"><?php echo $loc['name']; ?></div>
                    <div class="text-sm text-green-400"><?php echo $loc['ping']; ?></div>
                </div>
            <?php endforeach; ?>
        </div>
    </div>
</section>

<!-- CTA -->
<section class="py-20 px-4">
    <div class="max-w-4xl mx-auto">
        <div class="glass rounded-3xl p-8 md:p-12 text-center bg-gradient-to-r from-primary-500/20 to-secondary-500/20">
            <h2 class="text-3xl font-bold mb-4">آماده شروع هستید؟</h2>
            <p class="text-gray-400 mb-8">همین الان ثبت‌نام کنید و از اینترنت آزاد لذت ببرید</p>
            
            <a href="?page=register" class="inline-flex items-center gap-2 px-8 py-4 rounded-xl bg-gradient-to-r from-primary-500 to-secondary-500 font-bold text-lg hover:opacity-90 transition-opacity">
                ثبت‌نام رایگان
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 7l5 5m0 0l-5 5m5-5H6"></path>
                </svg>
            </a>
        </div>
    </div>
</section>

<!-- فوتر -->
<footer class="py-8 px-4 border-t border-white/10">
    <div class="max-w-6xl mx-auto">
        <div class="flex flex-col md:flex-row items-center justify-between gap-4">
            <div class="flex items-center gap-2">
                <div class="w-10 h-10 rounded-xl bg-gradient-to-r from-primary-500 to-secondary-500 flex items-center justify-center">
                    <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"></path>
                    </svg>
                </div>
                <span class="font-bold"><?php echo getSetting('site_name', 'VPN Shop'); ?></span>
            </div>
            
            <div class="flex items-center gap-6 text-gray-400">
                <a href="<?php echo getSetting('telegram_channel'); ?>" target="_blank" class="hover:text-white">تلگرام</a>
                <a href="?page=tutorials" class="hover:text-white">آموزش</a>
                <a href="?page=login" class="hover:text-white">ورود</a>
            </div>
            
            <div class="text-gray-500 text-sm">
                © <?php echo date('Y'); ?> - تمامی حقوق محفوظ است
            </div>
        </div>
    </div>
</footer>