<?php
/**
 * مدیریت آموزش‌ها و دانلودها - پنل ادمین
 */
function renderAdminTutorials() {
?>
<main class="pr-0 lg:pr-64 pt-16 min-h-screen">
    <div class="p-4 lg:p-8">
        <!-- هدر صفحه -->
        <div class="flex flex-col md:flex-row md:items-center md:justify-between gap-4 mb-8">
            <div>
                <h1 class="text-2xl font-bold">مدیریت آموزش‌ها</h1>
                <p class="text-gray-400 mt-1">مدیریت فایل‌های آموزشی و لینک‌های دانلود</p>
            </div>
            <div class="flex gap-3">
                <button onclick="openAddTutorialModal()" class="bg-gradient-to-r from-primary-500 to-secondary-500 rounded-xl px-6 py-2.5 font-medium hover:opacity-90 transition-opacity flex items-center gap-2">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6v6m0 0v6m0-6h6m-6 0H6"></path>
                    </svg>
                    آموزش جدید
                </button>
                <button onclick="openAddAppModal()" class="glass rounded-xl px-6 py-2.5 font-medium hover:bg-white/10 transition-colors flex items-center gap-2">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16v1a3 3 0 003 3h10a3 3 0 003-3v-1m-4-4l-4 4m0 0l-4-4m4 4V4"></path>
                    </svg>
                    اپلیکیشن جدید
                </button>
            </div>
        </div>

        <!-- تب‌ها -->
        <div class="flex items-center gap-2 mb-6">
            <button onclick="showTutorialAdminTab('tutorials')" class="tutorial-admin-tab active px-6 py-2.5 rounded-xl bg-primary-500 text-white font-medium" data-tab="tutorials">
                آموزش‌ها
            </button>
            <button onclick="showTutorialAdminTab('apps')" class="tutorial-admin-tab px-6 py-2.5 rounded-xl glass hover:bg-white/10 font-medium" data-tab="apps">
                اپلیکیشن‌ها
            </button>
        </div>

        <!-- محتوای آموزش‌ها -->
        <div id="tutorialsAdminTab" class="tutorial-admin-content">
            <div class="glass rounded-3xl overflow-hidden">
                <div class="overflow-x-auto">
                    <table class="w-full">
                        <thead>
                            <tr class="text-gray-400 text-sm border-b border-white/10">
                                <th class="text-right p-4">عنوان</th>
                                <th class="text-right p-4">پلتفرم</th>
                                <th class="text-right p-4">ترتیب</th>
                                <th class="text-right p-4">وضعیت</th>
                                <th class="text-center p-4">عملیات</th>
                            </tr>
                        </thead>
                        <tbody id="tutorialsAdminTable">
                            <!-- داده‌ها با AJAX لود می‌شوند -->
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <!-- محتوای اپلیکیشن‌ها -->
        <div id="appsAdminTab" class="tutorial-admin-content hidden">
            <div class="grid grid-cols-1 md:grid-cols-2 lg:grid-cols-3 gap-4" id="appsAdminGrid">
                <!-- اپلیکیشن‌ها با AJAX لود می‌شوند -->
            </div>
        </div>
    </div>
</main>

<!-- Modal آموزش -->
<div id="tutorialModal" class="fixed inset-0 z-50 hidden items-center justify-center p-4 bg-black/50 backdrop-blur-sm">
    <div class="glass rounded-3xl p-6 w-full max-w-2xl animate-scale-in max-h-[90vh] overflow-y-auto">
        <div class="flex items-center justify-between mb-6">
            <h3 class="text-lg font-bold" id="tutorialModalTitle">آموزش جدید</h3>
            <button onclick="closeTutorialModal()" class="w-8 h-8 rounded-full bg-white/10 flex items-center justify-center hover:bg-red-500/20">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                </svg>
            </button>
        </div>
        
        <form id="tutorialForm" class="space-y-4">
            <input type="hidden" name="tutorial_id" id="editTutorialId">
            
            <div class="grid grid-cols-2 gap-4">
                <div>
                    <label class="block text-sm text-gray-400 mb-2">عنوان</label>
                    <input type="text" name="title" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 focus:border-primary-500 outline-none" required>
                </div>
                <div>
                    <label class="block text-sm text-gray-400 mb-2">پلتفرم</label>
                    <select name="platform" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 focus:border-primary-500 outline-none" required>
                        <option value="android">اندروید</option>
                        <option value="ios">iOS</option>
                        <option value="windows">ویندوز</option>
                        <option value="macos">macOS</option>
                        <option value="general">عمومی</option>
                    </select>
                </div>
            </div>
            
            <div>
                <label class="block text-sm text-gray-400 mb-2">توضیح کوتاه</label>
                <input type="text" name="description" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 focus:border-primary-500 outline-none">
            </div>
            
            <div>
                <label class="block text-sm text-gray-400 mb-2">محتوای آموزش</label>
                <div class="space-y-2" id="tutorialSteps">
                    <div class="flex gap-2 step-item">
                        <input type="text" name="steps[]" class="flex-1 bg-white/5 border border-white/10 rounded-xl px-4 py-3 focus:border-primary-500 outline-none" placeholder="مرحله 1">
                        <button type="button" onclick="removeStep(this)" class="px-3 py-3 rounded-xl bg-red-500/20 text-red-400 hover:bg-red-500/30">
                            <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"></path>
                            </svg>
                        </button>
                    </div>
                </div>
                <button type="button" onclick="addStep()" class="mt-2 w-full glass rounded-xl py-2 text-sm hover:bg-white/10">
                    + افزودن مرحله
                </button>
            </div>
            
            <div class="grid grid-cols-2 gap-4">
                <div>
                    <label class="block text-sm text-gray-400 mb-2">ترتیب نمایش</label>
                    <input type="number" name="sort_order" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 focus:border-primary-500 outline-none" value="0">
                </div>
                <div class="flex items-end">
                    <label class="flex items-center gap-3 p-3 bg-white/5 rounded-xl cursor-pointer w-full">
                        <input type="checkbox" name="is_active" class="toggle-switch" checked>
                        <span>فعال</span>
                    </label>
                </div>
            </div>
            
            <div class="flex gap-3 pt-4">
                <button type="submit" class="flex-1 bg-gradient-to-r from-primary-500 to-secondary-500 rounded-xl py-3 font-medium hover:opacity-90">
                    ذخیره
                </button>
                <button type="button" onclick="closeTutorialModal()" class="flex-1 glass rounded-xl py-3 font-medium hover:bg-white/10">
                    انصراف
                </button>
            </div>
        </form>
    </div>
</div>

<!-- Modal اپلیکیشن -->
<div id="appModal" class="fixed inset-0 z-50 hidden items-center justify-center p-4 bg-black/50 backdrop-blur-sm">
    <div class="glass rounded-3xl p-6 w-full max-w-lg animate-scale-in">
        <div class="flex items-center justify-between mb-6">
            <h3 class="text-lg font-bold" id="appModalTitle">اپلیکیشن جدید</h3>
            <button onclick="closeAppModal()" class="w-8 h-8 rounded-full bg-white/10 flex items-center justify-center hover:bg-red-500/20">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                </svg>
            </button>
        </div>
        
        <form id="appForm" class="space-y-4">
            <input type="hidden" name="app_id" id="editAppId">
            
            <div>
                <label class="block text-sm text-gray-400 mb-2">نام اپلیکیشن</label>
                <input type="text" name="name" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 focus:border-primary-500 outline-none" placeholder="V2rayNG" required>
            </div>
            
            <div>
                <label class="block text-sm text-gray-400 mb-2">پلتفرم</label>
                <select name="platform" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 focus:border-primary-500 outline-none" required>
                    <option value="android">🤖 اندروید</option>
                    <option value="ios">🍎 iOS</option>
                    <option value="windows">💻 ویندوز</option>
                    <option value="macos">🖥️ macOS</option>
                </select>
            </div>
            
            <div>
                <label class="block text-sm text-gray-400 mb-2">لینک دانلود</label>
                <input type="url" name="download_url" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 focus:border-primary-500 outline-none" required>
            </div>
            
            <div>
                <label class="block text-sm text-gray-400 mb-2">نسخه</label>
                <input type="text" name="version" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 focus:border-primary-500 outline-none" placeholder="1.0.0">
            </div>
            
            <div class="grid grid-cols-2 gap-4">
                <div>
                    <label class="block text-sm text-gray-400 mb-2">ترتیب</label>
                    <input type="number" name="sort_order" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 focus:border-primary-500 outline-none" value="0">
                </div>
                <div class="flex items-end">
                    <label class="flex items-center gap-3 p-3 bg-white/5 rounded-xl cursor-pointer w-full">
                        <input type="checkbox" name="is_active" class="toggle-switch" checked>
                        <span>فعال</span>
                    </label>
                </div>
            </div>
            
            <div class="flex gap-3 pt-4">
                <button type="submit" class="flex-1 bg-gradient-to-r from-primary-500 to-secondary-500 rounded-xl py-3 font-medium hover:opacity-90">
                    ذخیره
                </button>
                <button type="button" onclick="closeAppModal()" class="flex-1 glass rounded-xl py-3 font-medium hover:bg-white/10">
                    انصراف
                </button>
            </div>
        </form>
    </div>
</div>

<script>
// نمایش تب
function showTutorialAdminTab(tab) {
    document.querySelectorAll('.tutorial-admin-content').forEach(el => el.classList.add('hidden'));
    document.querySelectorAll('.tutorial-admin-tab').forEach(t => {
        if (t.dataset.tab === tab) {
            t.classList.add('active', 'bg-primary-500', 'text-white');
            t.classList.remove('glass');
        } else {
            t.classList.remove('active', 'bg-primary-500', 'text-white');
            t.classList.add('glass');
        }
    });
    
    document.getElementById(tab + 'AdminTab')?.classList.remove('hidden');
    
    if (tab === 'tutorials') loadTutorialsAdmin();
    else if (tab === 'apps') loadAppsAdmin();
}

// لود آموزش‌ها
async function loadTutorialsAdmin() {
    try {
        const response = await fetch('api.php?action=admin_get_tutorials');
        const data = await response.json();
        
        if (data.success) {
            renderTutorialsAdminTable(data.tutorials);
        }
    } catch (error) {
        console.error('Error loading tutorials:', error);
    }
}

function renderTutorialsAdminTable(tutorials) {
    const tbody = document.getElementById('tutorialsAdminTable');
    
    if (tutorials.length === 0) {
        tbody.innerHTML = `
            <tr>
                <td colspan="5" class="text-center py-12 text-gray-400">آموزشی یافت نشد</td>
            </tr>
        `;
        return;
    }
    
    tbody.innerHTML = tutorials.map(tutorial => `
        <tr class="border-b border-white/5 hover:bg-white/5">
            <td class="p-4">
                <div class="font-medium">${tutorial.title}</div>
                <div class="text-sm text-gray-400">${tutorial.description || ''}</div>
            </td>
            <td class="p-4">
                <span class="px-2 py-1 rounded-lg text-xs ${getPlatformClass(tutorial.platform)}">
                    ${getPlatformText(tutorial.platform)}
                </span>
            </td>
            <td class="p-4 text-gray-400">${tutorial.sort_order}</td>
            <td class="p-4">
                <span class="px-2 py-1 rounded-lg text-xs ${tutorial.is_active ? 'bg-green-500/20 text-green-400' : 'bg-gray-500/20 text-gray-400'}">
                    ${tutorial.is_active ? 'فعال' : 'غیرفعال'}
                </span>
            </td>
            <td class="p-4">
                <div class="flex items-center justify-center gap-2">
                    <button onclick="editTutorial(${tutorial.id})" class="w-8 h-8 rounded-lg bg-yellow-500/20 text-yellow-400 flex items-center justify-center hover:bg-yellow-500/30">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M11 5H6a2 2 0 00-2 2v11a2 2 0 002 2h11a2 2 0 002-2v-5m-1.414-9.414a2 2 0 112.828 2.828L11.828 15H9v-2.828l8.586-8.586z"></path>
                        </svg>
                    </button>
                    <button onclick="deleteTutorial(${tutorial.id})" class="w-8 h-8 rounded-lg bg-red-500/20 text-red-400 flex items-center justify-center hover:bg-red-500/30">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"></path>
                        </svg>
                    </button>
                </div>
            </td>
        </tr>
    `).join('');
}

// لود اپلیکیشن‌ها
async function loadAppsAdmin() {
    try {
        const response = await fetch('api.php?action=admin_get_apps');
        const data = await response.json();
        
        if (data.success) {
            renderAppsAdminGrid(data.apps);
        }
    } catch (error) {
        console.error('Error loading apps:', error);
    }
}

function renderAppsAdminGrid(apps) {
    const grid = document.getElementById('appsAdminGrid');
    
    grid.innerHTML = apps.map(app => `
        <div class="glass rounded-2xl p-4">
            <div class="flex items-center justify-between mb-3">
                <div class="flex items-center gap-3">
                    <div class="w-12 h-12 rounded-xl ${getPlatformBg(app.platform)} flex items-center justify-center text-2xl">
                        ${getPlatformIcon(app.platform)}
                    </div>
                    <div>
                        <div class="font-bold">${app.name}</div>
                        <div class="text-sm text-gray-400">${getPlatformText(app.platform)}</div>
                    </div>
                </div>
                <span class="px-2 py-1 rounded text-xs ${app.is_active ? 'bg-green-500/20 text-green-400' : 'bg-gray-500/20 text-gray-400'}">
                    ${app.is_active ? 'فعال' : 'غیرفعال'}
                </span>
            </div>
            <div class="text-sm text-gray-400 mb-3">نسخه: ${app.version || '-'}</div>
            <div class="flex gap-2">
                <button onclick="editApp(${app.id})" class="flex-1 glass rounded-lg py-2 text-sm hover:bg-white/10">ویرایش</button>
                <button onclick="deleteApp(${app.id})" class="glass rounded-lg py-2 px-3 text-red-400 hover:bg-red-500/20">
                    <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"></path>
                    </svg>
                </button>
            </div>
        </div>
    `).join('');
}

// Modal آموزش
function openAddTutorialModal() {
    document.getElementById('tutorialModalTitle').textContent = 'آموزش جدید';
    document.getElementById('tutorialForm').reset();
    document.getElementById('editTutorialId').value = '';
    document.getElementById('tutorialSteps').innerHTML = `
        <div class="flex gap-2 step-item">
            <input type="text" name="steps[]" class="flex-1 bg-white/5 border border-white/10 rounded-xl px-4 py-3 focus:border-primary-500 outline-none" placeholder="مرحله 1">
            <button type="button" onclick="removeStep(this)" class="px-3 py-3 rounded-xl bg-red-500/20 text-red-400 hover:bg-red-500/30">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"></path>
                </svg>
            </button>
        </div>
    `;
    document.getElementById('tutorialModal').classList.remove('hidden');
    document.getElementById('tutorialModal').classList.add('flex');
}

function closeTutorialModal() {
    document.getElementById('tutorialModal').classList.add('hidden');
    document.getElementById('tutorialModal').classList.remove('flex');
}

function addStep() {
    const container = document.getElementById('tutorialSteps');
    const stepCount = container.querySelectorAll('.step-item').length + 1;
    
    const stepHTML = `
        <div class="flex gap-2 step-item">
            <input type="text" name="steps[]" class="flex-1 bg-white/5 border border-white/10 rounded-xl px-4 py-3 focus:border-primary-500 outline-none" placeholder="مرحله ${stepCount}">
            <button type="button" onclick="removeStep(this)" class="px-3 py-3 rounded-xl bg-red-500/20 text-red-400 hover:bg-red-500/30">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M19 7l-.867 12.142A2 2 0 0116.138 21H7.862a2 2 0 01-1.995-1.858L5 7m5 4v6m4-6v6m1-10V4a1 1 0 00-1-1h-4a1 1 0 00-1 1v3M4 7h16"></path>
                </svg>
            </button>
        </div>
    `;
    container.insertAdjacentHTML('beforeend', stepHTML);
}

function removeStep(btn) {
    btn.closest('.step-item').remove();
}

// Modal اپلیکیشن
function openAddAppModal() {
    document.getElementById('appModalTitle').textContent = 'اپلیکیشن جدید';
    document.getElementById('appForm').reset();
    document.getElementById('editAppId').value = '';
    document.getElementById('appModal').classList.remove('hidden');
    document.getElementById('appModal').classList.add('flex');
}

function closeAppModal() {
    document.getElementById('appModal').classList.add('hidden');
    document.getElementById('appModal').classList.remove('flex');
}

// ذخیره آموزش
document.getElementById('tutorialForm')?.addEventListener('submit', async function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    formData.append('action', formData.get('tutorial_id') ? 'admin_update_tutorial' : 'admin_add_tutorial');
    formData.append('is_active', this.querySelector('[name="is_active"]').checked ? '1' : '0');
    
    try {
        const response = await fetch('api.php', { method: 'POST', body: formData });
        const data = await response.json();
        
        if (data.success) {
            showToast(data.message, 'success');
            closeTutorialModal();
            loadTutorialsAdmin();
        } else {
            showToast(data.message, 'error');
        }
    } catch (error) {
        showToast('خطا در ذخیره', 'error');
    }
});

// ذخیره اپلیکیشن
document.getElementById('appForm')?.addEventListener('submit', async function(e) {
    e.preventDefault();
    
    const formData = new FormData(this);
    formData.append('action', formData.get('app_id') ? 'admin_update_app' : 'admin_add_app');
    formData.append('is_active', this.querySelector('[name="is_active"]').checked ? '1' : '0');
    
    try {
        const response = await fetch('api.php', { method: 'POST', body: formData });
        const data = await response.json();
        
        if (data.success) {
            showToast(data.message, 'success');
            closeAppModal();
            loadAppsAdmin();
        } else {
            showToast(data.message, 'error');
        }
    } catch (error) {
        showToast('خطا در ذخیره', 'error');
    }
});

// توابع کمکی
function getPlatformClass(platform) {
    const classes = {
        'android': 'bg-green-500/20 text-green-400',
        'ios': 'bg-blue-500/20 text-blue-400',
        'windows': 'bg-blue-600/20 text-blue-300',
        'macos': 'bg-gray-500/20 text-gray-300',
        'general': 'bg-purple-500/20 text-purple-400'
    };
    return classes[platform] || classes['general'];
}

function getPlatformText(platform) {
    const texts = { 'android': 'اندروید', 'ios': 'iOS', 'windows': 'ویندوز', 'macos': 'macOS', 'general': 'عمومی' };
    return texts[platform] || platform;
}

function getPlatformBg(platform) {
    const bgs = {
        'android': 'bg-green-500/20',
        'ios': 'bg-blue-500/20',
        'windows': 'bg-blue-600/20',
        'macos': 'bg-gray-500/20'
    };
    return bgs[platform] || 'bg-purple-500/20';
}

function getPlatformIcon(platform) {
    const icons = { 'android': '🤖', 'ios': '🍎', 'windows': '💻', 'macos': '🖥️' };
    return icons[platform] || '📱';
}

// لود اولیه
document.addEventListener('DOMContentLoaded', loadTutorialsAdmin);
</script>
<?php
}
?>