<?php
/**
 * صفحه مدیریت زیرمجموعه‌ها (رفرال)
 */
function renderAdminReferrals() {
?>
<main class="pr-0 lg:pr-64 pt-16 min-h-screen">
    <div class="p-4 lg:p-8">
        <!-- هدر صفحه -->
        <div class="flex flex-col md:flex-row md:items-center md:justify-between gap-4 mb-8">
            <div>
                <h1 class="text-2xl font-bold">مدیریت زیرمجموعه‌ها</h1>
                <p class="text-gray-400 mt-1">مشاهده و مدیریت سیستم رفرال</p>
            </div>
        </div>

        <!-- آمار رفرال -->
        <div class="grid grid-cols-2 md:grid-cols-4 gap-4 mb-6">
            <div class="glass rounded-2xl p-4">
                <div class="flex items-center gap-3">
                    <div class="w-12 h-12 rounded-xl bg-purple-500/20 flex items-center justify-center">
                        <svg class="w-6 h-6 text-purple-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M17 20h5v-2a3 3 0 00-5.356-1.857M17 20H7m10 0v-2c0-.656-.126-1.283-.356-1.857M7 20H2v-2a3 3 0 015.356-1.857M7 20v-2c0-.656.126-1.283.356-1.857m0 0a5.002 5.002 0 019.288 0M15 7a3 3 0 11-6 0 3 3 0 016 0z"></path>
                        </svg>
                    </div>
                    <div>
                        <div class="text-2xl font-bold" id="totalReferrals">0</div>
                        <div class="text-sm text-gray-400">کل زیرمجموعه‌ها</div>
                    </div>
                </div>
            </div>
            <div class="glass rounded-2xl p-4">
                <div class="flex items-center gap-3">
                    <div class="w-12 h-12 rounded-xl bg-green-500/20 flex items-center justify-center">
                        <svg class="w-6 h-6 text-green-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8c-1.657 0-3 .895-3 2s1.343 2 3 2 3 .895 3 2-1.343 2-3 2m0-8c1.11 0 2.08.402 2.599 1M12 8V7m0 1v8m0 0v1m0-1c-1.11 0-2.08-.402-2.599-1M21 12a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                    </div>
                    <div>
                        <div class="text-2xl font-bold" id="totalCommissions">0</div>
                        <div class="text-sm text-gray-400">کل کمیسیون (تومان)</div>
                    </div>
                </div>
            </div>
            <div class="glass rounded-2xl p-4">
                <div class="flex items-center gap-3">
                    <div class="w-12 h-12 rounded-xl bg-blue-500/20 flex items-center justify-center">
                        <svg class="w-6 h-6 text-blue-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M9 12l2 2 4-4m6 2a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                    </div>
                    <div>
                        <div class="text-2xl font-bold" id="paidCommissions">0</div>
                        <div class="text-sm text-gray-400">پرداخت شده</div>
                    </div>
                </div>
            </div>
            <div class="glass rounded-2xl p-4">
                <div class="flex items-center gap-3">
                    <div class="w-12 h-12 rounded-xl bg-yellow-500/20 flex items-center justify-center">
                        <svg class="w-6 h-6 text-yellow-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 8v4l3 3m6-3a9 9 0 11-18 0 9 9 0 0118 0z"></path>
                        </svg>
                    </div>
                    <div>
                        <div class="text-2xl font-bold" id="pendingCommissions">0</div>
                        <div class="text-sm text-gray-400">در انتظار</div>
                    </div>
                </div>
            </div>
        </div>

        <!-- تب‌ها -->
        <div class="flex items-center gap-2 mb-6">
            <button onclick="showReferralTab('users')" class="referral-tab active px-6 py-2.5 rounded-xl bg-primary-500 text-white font-medium" data-tab="users">
                کاربران با زیرمجموعه
            </button>
            <button onclick="showReferralTab('commissions')" class="referral-tab px-6 py-2.5 rounded-xl glass hover:bg-white/10 font-medium" data-tab="commissions">
                کمیسیون‌ها
            </button>
            <button onclick="showReferralTab('withdrawals')" class="referral-tab px-6 py-2.5 rounded-xl glass hover:bg-white/10 font-medium" data-tab="withdrawals">
                درخواست‌های برداشت
            </button>
        </div>

        <!-- محتوای تب کاربران -->
        <div id="referralUsersTab" class="referral-content">
            <div class="glass rounded-3xl p-6 mb-6">
                <div class="relative">
                    <input type="text" id="searchReferralUsers" class="w-full bg-white/5 border border-white/10 rounded-xl px-4 py-3 pr-12 focus:border-primary-500 outline-none" placeholder="جستجو کاربر...">
                    <svg class="w-5 h-5 absolute right-4 top-1/2 -translate-y-1/2 text-gray-400" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"></path>
                    </svg>
                </div>
            </div>

            <div class="glass rounded-3xl overflow-hidden">
                <div class="overflow-x-auto">
                    <table class="w-full">
                        <thead>
                            <tr class="text-gray-400 text-sm border-b border-white/10">
                                <th class="text-right p-4">کاربر</th>
                                <th class="text-right p-4">کد رفرال</th>
                                <th class="text-right p-4">تعداد زیرمجموعه</th>
                                <th class="text-right p-4">کل کمیسیون</th>
                                <th class="text-right p-4">موجودی کمیسیون</th>
                                <th class="text-center p-4">عملیات</th>
                            </tr>
                        </thead>
                        <tbody id="referralUsersTable">
                            <!-- داده‌ها با AJAX لود می‌شوند -->
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <!-- محتوای تب کمیسیون‌ها -->
        <div id="referralCommissionsTab" class="referral-content hidden">
            <div class="glass rounded-3xl overflow-hidden">
                <div class="overflow-x-auto">
                    <table class="w-full">
                        <thead>
                            <tr class="text-gray-400 text-sm border-b border-white/10">
                                <th class="text-right p-4">معرف</th>
                                <th class="text-right p-4">زیرمجموعه</th>
                                <th class="text-right p-4">سفارش</th>
                                <th class="text-right p-4">مبلغ سفارش</th>
                                <th class="text-right p-4">کمیسیون</th>
                                <th class="text-right p-4">وضعیت</th>
                                <th class="text-right p-4">تاریخ</th>
                            </tr>
                        </thead>
                        <tbody id="commissionsTable">
                            <!-- داده‌ها با AJAX لود می‌شوند -->
                        </tbody>
                    </table>
                </div>
            </div>
        </div>

        <!-- محتوای تب درخواست‌های برداشت -->
        <div id="referralWithdrawalsTab" class="referral-content hidden">
            <div class="glass rounded-3xl overflow-hidden">
                <div class="overflow-x-auto">
                    <table class="w-full">
                        <thead>
                            <tr class="text-gray-400 text-sm border-b border-white/10">
                                <th class="text-right p-4">کاربر</th>
                                <th class="text-right p-4">مبلغ</th>
                                <th class="text-right p-4">شماره کارت</th>
                                <th class="text-right p-4">وضعیت</th>
                                <th class="text-right p-4">تاریخ درخواست</th>
                                <th class="text-center p-4">عملیات</th>
                            </tr>
                        </thead>
                        <tbody id="withdrawalsTable">
                            <!-- داده‌ها با AJAX لود می‌شوند -->
                        </tbody>
                    </table>
                </div>
            </div>
        </div>
    </div>
</main>

<!-- Modal جزئیات زیرمجموعه‌ها -->
<div id="referralDetailModal" class="fixed inset-0 z-50 hidden items-center justify-center p-4 bg-black/50 backdrop-blur-sm">
    <div class="glass rounded-3xl p-6 w-full max-w-2xl animate-scale-in max-h-[90vh] overflow-y-auto">
        <div class="flex items-center justify-between mb-6">
            <h3 class="text-lg font-bold">زیرمجموعه‌های <span id="referralUsername"></span></h3>
            <button onclick="closeReferralDetailModal()" class="w-8 h-8 rounded-full bg-white/10 flex items-center justify-center hover:bg-red-500/20">
                <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                </svg>
            </button>
        </div>
        <div id="referralDetailContent">
            <!-- محتوا با AJAX لود می‌شود -->
        </div>
    </div>
</div>

<script>
// نمایش تب رفرال
function showReferralTab(tab) {
    document.querySelectorAll('.referral-content').forEach(el => el.classList.add('hidden'));
    document.querySelectorAll('.referral-tab').forEach(el => {
        el.classList.remove('active', 'bg-primary-500', 'text-white');
        el.classList.add('glass');
    });
    
    document.getElementById(`referral${tab.charAt(0).toUpperCase() + tab.slice(1)}Tab`)?.classList.remove('hidden');
    const activeTab = document.querySelector(`.referral-tab[data-tab="${tab}"]`);
    if (activeTab) {
        activeTab.classList.add('active', 'bg-primary-500', 'text-white');
        activeTab.classList.remove('glass');
    }
    
    if (tab === 'users') loadReferralUsers();
    if (tab === 'commissions') loadCommissions();
    if (tab === 'withdrawals') loadWithdrawals();
}

// لود کاربران با زیرمجموعه
async function loadReferralUsers() {
    try {
        const response = await fetch('api.php?action=admin_get_referral_users');
        const data = await response.json();
        
        if (data.success) {
            document.getElementById('totalReferrals').textContent = numberFormat(data.stats.total_referrals);
            document.getElementById('totalCommissions').textContent = numberFormat(data.stats.total_commissions);
            document.getElementById('paidCommissions').textContent = numberFormat(data.stats.paid_commissions);
            document.getElementById('pendingCommissions').textContent = numberFormat(data.stats.pending_commissions);
            
            renderReferralUsersTable(data.users);
        }
    } catch (error) {
        console.error('Error loading referral users:', error);
    }
}

function renderReferralUsersTable(users) {
    const tbody = document.getElementById('referralUsersTable');
    
    if (users.length === 0) {
        tbody.innerHTML = `
            <tr>
                <td colspan="6" class="text-center py-12 text-gray-400">کاربری با زیرمجموعه یافت نشد</td>
            </tr>
        `;
        return;
    }
    
    tbody.innerHTML = users.map(user => `
        <tr class="border-b border-white/5 hover:bg-white/5">
            <td class="p-4">
                <div class="flex items-center gap-3">
                    <div class="w-8 h-8 rounded-full bg-gradient-to-r from-purple-500 to-pink-500 flex items-center justify-center text-sm font-bold">
                        ${user.username.charAt(0).toUpperCase()}
                    </div>
                    <div>
                        <div class="font-medium">${user.username}</div>
                        <div class="text-xs text-gray-400">${user.phone}</div>
                    </div>
                </div>
            </td>
            <td class="p-4">
                <code class="px-2 py-1 rounded bg-white/10 text-primary-400 font-mono text-sm">${user.referral_code}</code>
            </td>
            <td class="p-4">
                <span class="text-blue-400 font-medium">${user.referral_count}</span>
            </td>
            <td class="p-4">
                <span class="font-medium">${numberFormat(user.total_commission)}</span>
                <span class="text-xs text-gray-400">تومان</span>
            </td>
            <td class="p-4">
                <span class="text-green-400 font-medium">${numberFormat(user.commission_balance)}</span>
                <span class="text-xs text-gray-400">تومان</span>
            </td>
            <td class="p-4">
                <div class="flex items-center justify-center gap-2">
                    <button onclick="viewReferralDetail(${user.id}, '${user.username}')" class="w-8 h-8 rounded-lg bg-blue-500/20 text-blue-400 flex items-center justify-center hover:bg-blue-500/30" title="جزئیات">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M15 12a3 3 0 11-6 0 3 3 0 016 0z"></path>
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M2.458 12C3.732 7.943 7.523 5 12 5c4.478 0 8.268 2.943 9.542 7-1.274 4.057-5.064 7-9.542 7-4.477 0-8.268-2.943-9.542-7z"></path>
                        </svg>
                    </button>
                    <button onclick="adjustCommission(${user.id})" class="w-8 h-8 rounded-lg bg-green-500/20 text-green-400 flex items-center justify-center hover:bg-green-500/30" title="تنظیم کمیسیون">
                        <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                            <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M12 6V4m0 2a2 2 0 100 4m0-4a2 2 0 110 4m-6 8a2 2 0 100-4m0 4a2 2 0 110-4m0 4v2m0-6V4m6 6v10m6-2a2 2 0 100-4m0 4a2 2 0 110-4m0 4v2m0-6V4"></path>
                        </svg>
                    </button>
                </div>
            </td>
        </tr>
    `).join('');
}

// لود کمیسیون‌ها
async function loadCommissions() {
    try {
        const response = await fetch('api.php?action=admin_get_commissions');
        const data = await response.json();
        
        if (data.success) {
            renderCommissionsTable(data.commissions);
        }
    } catch (error) {
        console.error('Error loading commissions:', error);
    }
}

function renderCommissionsTable(commissions) {
    const tbody = document.getElementById('commissionsTable');
    
    tbody.innerHTML = commissions.map(com => `
        <tr class="border-b border-white/5">
            <td class="p-4">${com.referrer_username}</td>
            <td class="p-4">${com.referred_username}</td>
            <td class="p-4"><span class="text-primary-400">#${com.order_id}</span></td>
            <td class="p-4">${numberFormat(com.order_amount)} تومان</td>
            <td class="p-4 text-green-400 font-medium">${numberFormat(com.commission_amount)} تومان</td>
            <td class="p-4">
                <span class="px-3 py-1 rounded-full text-xs ${com.status === 'paid' ? 'bg-green-500/20 text-green-400' : 'bg-yellow-500/20 text-yellow-400'}">
                    ${com.status === 'paid' ? 'پرداخت شده' : 'در انتظار'}
                </span>
            </td>
            <td class="p-4 text-gray-400">${com.created_at}</td>
        </tr>
    `).join('');
}

// لود درخواست‌های برداشت
async function loadWithdrawals() {
    try {
        const response = await fetch('api.php?action=admin_get_withdrawals');
        const data = await response.json();
        
        if (data.success) {
            renderWithdrawalsTable(data.withdrawals);
        }
    } catch (error) {
        console.error('Error loading withdrawals:', error);
    }
}

function renderWithdrawalsTable(withdrawals) {
    const tbody = document.getElementById('withdrawalsTable');
    
    tbody.innerHTML = withdrawals.map(w => `
        <tr class="border-b border-white/5">
            <td class="p-4">${w.username}</td>
            <td class="p-4 font-medium">${numberFormat(w.amount)} تومان</td>
            <td class="p-4 font-mono text-sm">${w.card_number}</td>
            <td class="p-4">
                <span class="px-3 py-1 rounded-full text-xs ${getWithdrawalStatusClass(w.status)}">
                    ${getWithdrawalStatusText(w.status)}
                </span>
            </td>
            <td class="p-4 text-gray-400">${w.created_at}</td>
            <td class="p-4">
                ${w.status === 'pending' ? `
                    <div class="flex items-center justify-center gap-2">
                        <button onclick="approveWithdrawal(${w.id})" class="w-8 h-8 rounded-lg bg-green-500/20 text-green-400 flex items-center justify-center hover:bg-green-500/30" title="تایید">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M5 13l4 4L19 7"></path>
                            </svg>
                        </button>
                        <button onclick="rejectWithdrawal(${w.id})" class="w-8 h-8 rounded-lg bg-red-500/20 text-red-400 flex items-center justify-center hover:bg-red-500/30" title="رد">
                            <svg class="w-4 h-4" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                                <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M6 18L18 6M6 6l12 12"></path>
                            </svg>
                        </button>
                    </div>
                ` : '-'}
            </td>
        </tr>
    `).join('');
}

// تایید برداشت
async function approveWithdrawal(id) {
    if (!confirm('آیا از تایید این درخواست برداشت اطمینان دارید؟')) return;
    
    try {
        const response = await fetch('api.php', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({ action: 'admin_approve_withdrawal', id: id })
        });
        const data = await response.json();
        
        if (data.success) {
            showToast('درخواست تایید شد', 'success');
            loadWithdrawals();
        } else {
            showToast(data.message, 'error');
        }
    } catch (error) {
        showToast('خطا در تایید درخواست', 'error');
    }
}

// رد برداشت
async function rejectWithdrawal(id) {
    const reason = prompt('دلیل رد درخواست:');
    if (reason === null) return;
    
    try {
        const response = await fetch('api.php', {
            method: 'POST',
            headers: { 'Content-Type': 'application/json' },
            body: JSON.stringify({ action: 'admin_reject_withdrawal', id: id, reason: reason })
        });
        const data = await response.json();
        
        if (data.success) {
            showToast('درخواست رد شد', 'success');
            loadWithdrawals();
        } else {
            showToast(data.message, 'error');
        }
    } catch (error) {
        showToast('خطا در رد درخواست', 'error');
    }
}

function getWithdrawalStatusClass(status) {
    const classes = {
        'pending': 'bg-yellow-500/20 text-yellow-400',
        'approved': 'bg-green-500/20 text-green-400',
        'rejected': 'bg-red-500/20 text-red-400'
    };
    return classes[status] || classes['pending'];
}

function getWithdrawalStatusText(status) {
    const texts = { 'pending': 'در انتظار', 'approved': 'تایید شده', 'rejected': 'رد شده' };
    return texts[status] || status;
}

// لود اولیه
document.addEventListener('DOMContentLoaded', () => loadReferralUsers());
</script>
<?php
}
?>