-- ============================================
-- دیتابیس سیستم فروش کانفیگ VPN
-- ============================================

SET NAMES utf8mb4;
SET FOREIGN_KEY_CHECKS = 0;

-- ----------------------------
-- جدول کاربران
-- ----------------------------
DROP TABLE IF EXISTS `users`;
CREATE TABLE `users` (
    `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
    `username` varchar(50) NOT NULL,
    `email` varchar(100) DEFAULT NULL,
    `phone` varchar(15) NOT NULL,
    `password` varchar(255) NOT NULL,
    `role` enum('user','vip','reseller','admin') DEFAULT 'user',
    `status` enum('active','blocked','pending') DEFAULT 'active',
    `balance` bigint(20) DEFAULT 0,
    `commission_balance` bigint(20) DEFAULT 0,
    `referral_code` varchar(20) NOT NULL,
    `referred_by` int(11) UNSIGNED DEFAULT NULL,
    `max_devices` int(11) DEFAULT 2,
    `admin_note` text DEFAULT NULL,
    `last_login` datetime DEFAULT NULL,
    `last_ip` varchar(45) DEFAULT NULL,
    `created_at` timestamp DEFAULT CURRENT_TIMESTAMP,
    `updated_at` timestamp DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    PRIMARY KEY (`id`),
    UNIQUE KEY `username` (`username`),
    UNIQUE KEY `phone` (`phone`),
    UNIQUE KEY `referral_code` (`referral_code`),
    KEY `referred_by` (`referred_by`),
    KEY `status` (`status`),
    KEY `role` (`role`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_persian_ci;

-- ----------------------------
-- جدول محصولات (کانفیگ‌ها)
-- ----------------------------
DROP TABLE IF EXISTS `products`;
CREATE TABLE `products` (
    `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
    `name` varchar(100) NOT NULL,
    `description` text DEFAULT NULL,
    `type` enum('vless','vmess','trojan','shadowsocks','netmod') NOT NULL,
    `location` varchar(50) NOT NULL,
    `price` bigint(20) NOT NULL,
    `old_price` bigint(20) DEFAULT NULL,
    `duration` int(11) NOT NULL DEFAULT 30 COMMENT 'روز',
    `traffic` int(11) DEFAULT NULL COMMENT 'GB - NULL = نامحدود',
    `max_devices` int(11) DEFAULT 2,
    `stock` int(11) DEFAULT 1,
    `sold_count` int(11) DEFAULT 0,
    `is_active` tinyint(1) DEFAULT 1,
    `is_featured` tinyint(1) DEFAULT 0,
    `sort_order` int(11) DEFAULT 0,
    `created_at` timestamp DEFAULT CURRENT_TIMESTAMP,
    `updated_at` timestamp DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    PRIMARY KEY (`id`),
    KEY `type` (`type`),
    KEY `location` (`location`),
    KEY `is_active` (`is_active`),
    KEY `is_featured` (`is_featured`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_persian_ci;

-- ----------------------------
-- جدول کانفیگ‌های موجود
-- ----------------------------
DROP TABLE IF EXISTS `configs`;
CREATE TABLE `configs` (
    `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
    `product_id` int(11) UNSIGNED NOT NULL,
    `config_data` text NOT NULL,
    `config_name` varchar(100) DEFAULT NULL,
    `status` enum('available','sold','reserved','expired') DEFAULT 'available',
    `assigned_to` int(11) UNSIGNED DEFAULT NULL,
    `assigned_at` datetime DEFAULT NULL,
    `expires_at` datetime DEFAULT NULL,
    `used_traffic` bigint(20) DEFAULT 0 COMMENT 'bytes',
    `created_at` timestamp DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY (`id`),
    KEY `product_id` (`product_id`),
    KEY `status` (`status`),
    KEY `assigned_to` (`assigned_to`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_persian_ci;

-- ----------------------------
-- جدول سفارشات
-- ----------------------------
DROP TABLE IF EXISTS `orders`;
CREATE TABLE `orders` (
    `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
    `user_id` int(11) UNSIGNED NOT NULL,
    `product_id` int(11) UNSIGNED NOT NULL,
    `config_id` int(11) UNSIGNED DEFAULT NULL,
    `amount` bigint(20) NOT NULL,
    `discount_amount` bigint(20) DEFAULT 0,
    `discount_code` varchar(50) DEFAULT NULL,
    `payment_method` enum('wallet','card','gateway') NOT NULL,
    `receipt_image` varchar(255) DEFAULT NULL,
    `status` enum('pending','completed','rejected','cancelled','refunded') DEFAULT 'pending',
    `reject_reason` text DEFAULT NULL,
    `admin_note` text DEFAULT NULL,
    `completed_at` datetime DEFAULT NULL,
    `created_at` timestamp DEFAULT CURRENT_TIMESTAMP,
    `updated_at` timestamp DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    PRIMARY KEY (`id`),
    KEY `user_id` (`user_id`),
    KEY `product_id` (`product_id`),
    KEY `status` (`status`),
    KEY `payment_method` (`payment_method`),
    KEY `created_at` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_persian_ci;

-- ----------------------------
-- جدول تراکنش‌ها
-- ----------------------------
DROP TABLE IF EXISTS `transactions`;
CREATE TABLE `transactions` (
    `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
    `user_id` int(11) UNSIGNED NOT NULL,
    `amount` bigint(20) NOT NULL COMMENT 'مثبت = افزایش، منفی = کاهش',
    `type` enum('charge','purchase','refund','bonus','referral','withdrawal') NOT NULL,
    `description` varchar(255) DEFAULT NULL,
    `reference_id` int(11) UNSIGNED DEFAULT NULL,
    `status` enum('pending','completed','failed') DEFAULT 'completed',
    `created_at` timestamp DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY (`id`),
    KEY `user_id` (`user_id`),
    KEY `type` (`type`),
    KEY `status` (`status`),
    KEY `created_at` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_persian_ci;

-- ----------------------------
-- جدول درخواست‌های شارژ
-- ----------------------------
DROP TABLE IF EXISTS `charge_requests`;
CREATE TABLE `charge_requests` (
    `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
    `user_id` int(11) UNSIGNED NOT NULL,
    `amount` bigint(20) NOT NULL,
    `receipt_image` varchar(255) NOT NULL,
    `status` enum('pending','approved','rejected') DEFAULT 'pending',
    `reject_reason` text DEFAULT NULL,
    `admin_id` int(11) UNSIGNED DEFAULT NULL,
    `processed_at` datetime DEFAULT NULL,
    `created_at` timestamp DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY (`id`),
    KEY `user_id` (`user_id`),
    KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_persian_ci;

-- ----------------------------
-- جدول کدهای تخفیف
-- ----------------------------
DROP TABLE IF EXISTS `discounts`;
CREATE TABLE `discounts` (
    `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
    `code` varchar(50) NOT NULL,
    `type` enum('percent','fixed') DEFAULT 'percent',
    `value` int(11) NOT NULL,
    `min_amount` bigint(20) DEFAULT 0,
    `max_discount` bigint(20) DEFAULT NULL,
    `max_uses` int(11) DEFAULT NULL COMMENT 'NULL = نامحدود',
    `used_count` int(11) DEFAULT 0,
    `user_id` int(11) UNSIGNED DEFAULT NULL COMMENT 'اختصاصی برای کاربر خاص',
    `product_id` int(11) UNSIGNED DEFAULT NULL COMMENT 'اختصاصی برای محصول خاص',
    `expires_at` datetime DEFAULT NULL,
    `is_active` tinyint(1) DEFAULT 1,
    `created_at` timestamp DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY (`id`),
    UNIQUE KEY `code` (`code`),
    KEY `is_active` (`is_active`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_persian_ci;

-- ----------------------------
-- جدول تیکت‌ها
-- ----------------------------
DROP TABLE IF EXISTS `tickets`;
CREATE TABLE `tickets` (
    `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
    `user_id` int(11) UNSIGNED NOT NULL,
    `subject` varchar(200) NOT NULL,
    `department` enum('sales','technical','financial','general') DEFAULT 'general',
    `priority` enum('low','medium','high') DEFAULT 'medium',
    `status` enum('open','waiting','answered','closed') DEFAULT 'open',
    `closed_at` datetime DEFAULT NULL,
    `created_at` timestamp DEFAULT CURRENT_TIMESTAMP,
    `updated_at` timestamp DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    PRIMARY KEY (`id`),
    KEY `user_id` (`user_id`),
    KEY `status` (`status`),
    KEY `department` (`department`),
    KEY `priority` (`priority`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_persian_ci;

-- ----------------------------
-- جدول پیام‌های تیکت
-- ----------------------------
DROP TABLE IF EXISTS `ticket_messages`;
CREATE TABLE `ticket_messages` (
    `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
    `ticket_id` int(11) UNSIGNED NOT NULL,
    `user_id` int(11) UNSIGNED NOT NULL,
    `message` text NOT NULL,
    `attachment` varchar(255) DEFAULT NULL,
    `is_admin` tinyint(1) DEFAULT 0,
    `created_at` timestamp DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY (`id`),
    KEY `ticket_id` (`ticket_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_persian_ci;

-- ----------------------------
-- جدول نوتیفیکیشن‌ها
-- ----------------------------
DROP TABLE IF EXISTS `notifications`;
CREATE TABLE `notifications` (
    `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
    `user_id` int(11) UNSIGNED DEFAULT NULL COMMENT 'NULL = همه کاربران',
    `title` varchar(200) NOT NULL,
    `message` text NOT NULL,
    `type` enum('info','success','warning','danger') DEFAULT 'info',
    `is_read` tinyint(1) DEFAULT 0,
    `created_at` timestamp DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY (`id`),
    KEY `user_id` (`user_id`),
    KEY `is_read` (`is_read`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_persian_ci;

-- ----------------------------
-- جدول کمیسیون‌های رفرال
-- ----------------------------
DROP TABLE IF EXISTS `referral_commissions`;
CREATE TABLE `referral_commissions` (
    `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
    `referrer_id` int(11) UNSIGNED NOT NULL,
    `referred_id` int(11) UNSIGNED NOT NULL,
    `order_id` int(11) UNSIGNED NOT NULL,
    `order_amount` bigint(20) NOT NULL,
    `commission_amount` bigint(20) NOT NULL,
    `status` enum('pending','paid') DEFAULT 'paid',
    `created_at` timestamp DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY (`id`),
    KEY `referrer_id` (`referrer_id`),
    KEY `referred_id` (`referred_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_persian_ci;

-- ----------------------------
-- جدول درخواست‌های برداشت
-- ----------------------------
DROP TABLE IF EXISTS `withdrawals`;
CREATE TABLE `withdrawals` (
    `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
    `user_id` int(11) UNSIGNED NOT NULL,
    `amount` bigint(20) NOT NULL,
    `card_number` varchar(20) NOT NULL,
    `card_holder` varchar(100) DEFAULT NULL,
    `status` enum('pending','approved','rejected') DEFAULT 'pending',
    `reject_reason` text DEFAULT NULL,
    `admin_id` int(11) UNSIGNED DEFAULT NULL,
    `processed_at` datetime DEFAULT NULL,
    `created_at` timestamp DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY (`id`),
    KEY `user_id` (`user_id`),
    KEY `status` (`status`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_persian_ci;

-- ----------------------------
-- جدول دستگاه‌های متصل
-- ----------------------------
DROP TABLE IF EXISTS `devices`;
CREATE TABLE `devices` (
    `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
    `user_id` int(11) UNSIGNED NOT NULL,
    `config_id` int(11) UNSIGNED NOT NULL,
    `device_name` varchar(100) DEFAULT NULL,
    `device_type` varchar(50) DEFAULT NULL,
    `ip_address` varchar(45) DEFAULT NULL,
    `user_agent` text DEFAULT NULL,
    `last_connect` datetime DEFAULT NULL,
    `created_at` timestamp DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY (`id`),
    KEY `user_id` (`user_id`),
    KEY `config_id` (`config_id`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_persian_ci;

-- ----------------------------
-- جدول تنظیمات
-- ----------------------------
DROP TABLE IF EXISTS `settings`;
CREATE TABLE `settings` (
    `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
    `key` varchar(100) NOT NULL,
    `value` text DEFAULT NULL,
    `group` varchar(50) DEFAULT 'general',
    `updated_at` timestamp DEFAULT CURRENT_TIMESTAMP ON UPDATE CURRENT_TIMESTAMP,
    PRIMARY KEY (`id`),
    UNIQUE KEY `key` (`key`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_persian_ci;

-- ----------------------------
-- جدول لاگ‌ها
-- ----------------------------
DROP TABLE IF EXISTS `logs`;
CREATE TABLE `logs` (
    `id` int(11) UNSIGNED NOT NULL AUTO_INCREMENT,
    `user_id` int(11) UNSIGNED DEFAULT NULL,
    `action` varchar(100) NOT NULL,
    `description` text DEFAULT NULL,
    `ip_address` varchar(45) DEFAULT NULL,
    `user_agent` text DEFAULT NULL,
    `created_at` timestamp DEFAULT CURRENT_TIMESTAMP,
    PRIMARY KEY (`id`),
    KEY `user_id` (`user_id`),
    KEY `action` (`action`),
    KEY `created_at` (`created_at`)
) ENGINE=InnoDB DEFAULT CHARSET=utf8mb4 COLLATE=utf8mb4_persian_ci;

-- ----------------------------
-- درج تنظیمات اولیه
-- ----------------------------
INSERT INTO `settings` (`key`, `value`, `group`) VALUES
('site_name', 'VPN Shop', 'general'),
('site_url', 'https://example.com', 'general'),
('site_description', 'فروشگاه کانفیگ VPN', 'general'),
('support_email', 'support@example.com', 'general'),
('support_phone', '09123456789', 'general'),
('telegram_support', '@support', 'general'),
('telegram_channel', '@channel', 'general'),

('card_number', '6037-9974-1234-5678', 'payment'),
('card_holder', 'نام صاحب کارت', 'payment'),
('bank_name', 'mellat', 'payment'),
('payment_card_enabled', '1', 'payment'),
('payment_wallet_enabled', '1', 'payment'),

('referral_enabled', '1', 'referral'),
('referral_commission', '10', 'referral'),
('signup_bonus', '5000', 'referral'),
('referral_signup_bonus', '2000', 'referral'),
('min_withdrawal', '50000', 'referral'),

('primary_color', '#8B5CF6', 'appearance'),
('secondary_color', '#EC4899', 'appearance'),
('bg_color', '#0F172A', 'appearance'),

('registration_enabled', '1', 'security'),
('email_verification', '0', 'security'),
('login_limit', '1', 'security'),
('device_limit', '1', 'security'),
('maintenance_mode', '0', 'security'),

('default_max_devices', '2', 'general'),
('min_wallet_charge', '10000', 'general');

-- ----------------------------
-- درج کاربر ادمین اولیه
-- رمز عبور: admin123
-- ----------------------------
INSERT INTO `users` (`username`, `phone`, `password`, `role`, `status`, `referral_code`) VALUES
('admin', '09123456789', '$2y$10$92IXUNpkjO0rOQ5byMi.Ye4oKoEa3Ro9llC/.og/at2.uheWG/igi', 'admin', 'active', 'ADMIN001');

SET FOREIGN_KEY_CHECKS = 1;