<?php
// install.php - اجرا کنید برای نصب اولیه
require_once 'config.php';

try {
    $pdo = new PDO(
        "mysql:host=" . DB_HOST,
        DB_USER,
        DB_PASS,
        [PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION]
    );
    
    // ایجاد دیتابیس
    $pdo->exec("CREATE DATABASE IF NOT EXISTS " . DB_NAME . " CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci");
    $pdo->exec("USE " . DB_NAME);
    
    // جدول کانال‌ها
    $pdo->exec("
        CREATE TABLE IF NOT EXISTS channels (
            id INT AUTO_INCREMENT PRIMARY KEY,
            username VARCHAR(100) UNIQUE NOT NULL,
            title VARCHAR(255),
            subscribers INT DEFAULT 0,
            last_scan DATETIME,
            is_active TINYINT(1) DEFAULT 1,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
        )
    ");
    
    // جدول کانفیگ‌ها
    $pdo->exec("
        CREATE TABLE IF NOT EXISTS configs (
            id INT AUTO_INCREMENT PRIMARY KEY,
            channel_id INT,
            protocol ENUM('vless', 'vmess', 'trojan', 'ss') NOT NULL,
            config_raw TEXT NOT NULL,
            config_hash VARCHAR(64) UNIQUE,
            server VARCHAR(255),
            port INT,
            remark VARCHAR(255),
            is_tls TINYINT(1) DEFAULT 0,
            is_reality TINYINT(1) DEFAULT 0,
            transport VARCHAR(50),
            score INT DEFAULT 1,
            found_count INT DEFAULT 1,
            last_seen DATETIME,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP,
            FOREIGN KEY (channel_id) REFERENCES channels(id) ON DELETE CASCADE,
            INDEX idx_protocol (protocol),
            INDEX idx_score (score DESC),
            INDEX idx_hash (config_hash)
        )
    ");
    
    // جدول آمار
    $pdo->exec("
        CREATE TABLE IF NOT EXISTS stats (
            id INT AUTO_INCREMENT PRIMARY KEY,
            total_scans INT DEFAULT 0,
            total_configs INT DEFAULT 0,
            last_update DATETIME,
            created_at TIMESTAMP DEFAULT CURRENT_TIMESTAMP
        )
    ");
    
    $pdo->exec("INSERT INTO stats (total_scans, total_configs, last_update) VALUES (0, 0, NOW())");
    
    echo json_encode([
        'success' => true,
        'message' => '✅ نصب با موفقیت انجام شد!'
    ]);
    
} catch (PDOException $e) {
    echo json_encode([
        'success' => false,
        'message' => '❌ خطا: ' . $e->getMessage()
    ]);
}