<?php require_once 'config.php'; ?>
<!DOCTYPE html>
<html lang="fa" dir="rtl">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0, maximum-scale=1.0, user-scalable=no">
    <title><?= SITE_NAME ?> - کانفیگ رایگان VPN</title>
    
    <!-- PWA -->
    <link rel="manifest" href="manifest.json">
    <meta name="theme-color" content="#6366f1">
    <meta name="apple-mobile-web-app-capable" content="yes">
    
    <!-- Tailwind + Custom CSS -->
    <script src="https://cdn.tailwindcss.com"></script>
    <link href="https://cdn.jsdelivr.net/gh/rastikerdar/vazirmatn@v33.003/Vazirmatn-font-face.css" rel="stylesheet">
    
    <style>
        * { font-family: 'Vazirmatn', system-ui, sans-serif; }
        
        :root {
            --primary: #6366f1;
            --primary-dark: #4f46e5;
            --secondary: #8b5cf6;
            --accent: #06b6d4;
            --bg-dark: #0f0f23;
            --bg-card: #1a1a2e;
            --bg-card-hover: #25253d;
            --text-primary: #ffffff;
            --text-secondary: #a0a0b8;
            --border: #2d2d44;
            --success: #10b981;
            --warning: #f59e0b;
            --error: #ef4444;
        }
        
        body {
            background: linear-gradient(135deg, var(--bg-dark) 0%, #16162a 50%, #1a1a35 100%);
            min-height: 100vh;
            color: var(--text-primary);
        }
        
        /* Glass Effect */
        .glass {
            background: rgba(26, 26, 46, 0.8);
            backdrop-filter: blur(20px);
            border: 1px solid rgba(255, 255, 255, 0.1);
        }
        
        .glass-card {
            background: linear-gradient(145deg, rgba(26, 26, 46, 0.9), rgba(37, 37, 61, 0.6));
            backdrop-filter: blur(10px);
            border: 1px solid rgba(255, 255, 255, 0.08);
            transition: all 0.3s ease;
        }
        
        .glass-card:hover {
            transform: translateY(-2px);
            border-color: rgba(99, 102, 241, 0.3);
            box-shadow: 0 20px 40px rgba(0, 0, 0, 0.3);
        }
        
        /* Gradient Buttons */
        .btn-primary {
            background: linear-gradient(135deg, var(--primary) 0%, var(--secondary) 100%);
            transition: all 0.3s ease;
        }
        
        .btn-primary:hover {
            transform: translateY(-2px);
            box-shadow: 0 10px 30px rgba(99, 102, 241, 0.4);
        }
        
        /* Protocol Badges */
        .badge-vless { background: linear-gradient(135deg, #6366f1, #8b5cf6); }
        .badge-vmess { background: linear-gradient(135deg, #10b981, #059669); }
        .badge-trojan { background: linear-gradient(135deg, #f59e0b, #d97706); }
        .badge-ss { background: linear-gradient(135deg, #06b6d4, #0891b2); }
        
        /* Score Badge */
        .score-high { background: linear-gradient(135deg, #10b981, #059669); }
        .score-medium { background: linear-gradient(135deg, #f59e0b, #d97706); }
        .score-low { background: linear-gradient(135deg, #6b7280, #4b5563); }
        
        /* Animations */
        @keyframes pulse-slow {
            0%, 100% { opacity: 1; }
            50% { opacity: 0.6; }
        }
        
        @keyframes gradient-flow {
            0% { background-position: 0% 50%; }
            50% { background-position: 100% 50%; }
            100% { background-position: 0% 50%; }
        }
        
        .animate-gradient {
            background-size: 200% 200%;
            animation: gradient-flow 3s ease infinite;
        }
        
        /* Config Card */
        .config-text {
            font-family: 'JetBrains Mono', 'Fira Code', monospace;
            font-size: 0.7rem;
            word-break: break-all;
            line-height: 1.5;
        }
        
        /* Scrollbar */
        ::-webkit-scrollbar { width: 6px; }
        ::-webkit-scrollbar-track { background: var(--bg-dark); }
        ::-webkit-scrollbar-thumb { background: var(--primary); border-radius: 3px; }
        
        /* Toast */
        .toast {
            position: fixed;
            bottom: 100px;
            left: 50%;
            transform: translateX(-50%) translateY(100px);
            opacity: 0;
            transition: all 0.3s ease;
            z-index: 9999;
        }
        
        .toast.show {
            transform: translateX(-50%) translateY(0);
            opacity: 1;
        }
        
        /* Bottom Nav */
        .bottom-nav {
            position: fixed;
            bottom: 0;
            left: 0;
            right: 0;
            z-index: 1000;
        }
        
        /* Loading Skeleton */
        .skeleton {
            background: linear-gradient(90deg, var(--bg-card) 25%, var(--bg-card-hover) 50%, var(--bg-card) 75%);
            background-size: 200% 100%;
            animation: skeleton-loading 1.5s infinite;
        }
        
        @keyframes skeleton-loading {
            0% { background-position: 200% 0; }
            100% { background-position: -200% 0; }
        }
        
        /* Filter Pills */
        .filter-pill {
            transition: all 0.2s ease;
        }
        
        .filter-pill.active {
            background: linear-gradient(135deg, var(--primary), var(--secondary));
            color: white;
        }
        
        .filter-pill:not(.active):hover {
            background: var(--bg-card-hover);
        }
    </style>
</head>
<body class="pb-20">
    <!-- Header -->
    <header class="glass sticky top-0 z-50 px-4 py-4">
        <div class="max-w-lg mx-auto flex items-center justify-between">
            <div class="flex items-center gap-3">
                <div class="w-10 h-10 rounded-xl bg-gradient-to-br from-indigo-500 to-purple-600 flex items-center justify-center">
                    <svg class="w-6 h-6 text-white" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M13 10V3L4 14h7v7l9-11h-7z"/>
                    </svg>
                </div>
                <div>
                    <h1 class="text-xl font-bold bg-gradient-to-r from-indigo-400 to-purple-400 bg-clip-text text-transparent">
                        <?= SITE_NAME ?>
                    </h1>
                    <p class="text-xs text-gray-400">کانفیگ هوشمند</p>
                </div>
            </div>
            
            <div class="flex items-center gap-2">
                <button id="refreshBtn" class="p-2 rounded-lg bg-white/5 hover:bg-white/10 transition">
                    <svg class="w-5 h-5" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                        <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 4v5h.582m15.356 2A8.001 8.001 0 004.582 9m0 0H9m11 11v-5h-.581m0 0a8.003 8.003 0 01-15.357-2m15.357 2H15"/>
                    </svg>
                </button>
            </div>
        </div>
    </header>

    <!-- Stats Cards -->
    <section class="px-4 py-4">
        <div class="max-w-lg mx-auto grid grid-cols-3 gap-3">
            <div class="glass-card rounded-xl p-3 text-center">
                <div class="text-2xl font-bold text-indigo-400" id="statConfigs">-</div>
                <div class="text-xs text-gray-400">کانفیگ</div>
            </div>
            <div class="glass-card rounded-xl p-3 text-center">
                <div class="text-2xl font-bold text-green-400" id="statChannels">-</div>
                <div class="text-xs text-gray-400">کانال</div>
            </div>
            <div class="glass-card rounded-xl p-3 text-center">
                <div class="text-2xl font-bold text-purple-400" id="statOnline">-</div>
                <div class="text-xs text-gray-400">آنلاین</div>
            </div>
        </div>
    </section>

    <!-- Filters -->
    <section class="px-4 py-2">
        <div class="max-w-lg mx-auto">
            <div class="flex gap-2 overflow-x-auto pb-2 hide-scrollbar">
                <button class="filter-pill active flex-shrink-0 px-4 py-2 rounded-full text-sm glass" data-filter="all">
                    همه
                </button>
                <button class="filter-pill flex-shrink-0 px-4 py-2 rounded-full text-sm glass" data-filter="vless">
                    VLESS
                </button>
                <button class="filter-pill flex-shrink-0 px-4 py-2 rounded-full text-sm glass" data-filter="vmess">
                    VMESS
                </button>
                <button class="filter-pill flex-shrink-0 px-4 py-2 rounded-full text-sm glass" data-filter="trojan">
                    Trojan
                </button>
                <button class="filter-pill flex-shrink-0 px-4 py-2 rounded-full text-sm glass" data-filter="ss">
                    SS
                </button>
                <button class="filter-pill flex-shrink-0 px-4 py-2 rounded-full text-sm glass" data-filter="light">
                    ⚡ سبک
                </button>
            </div>
        </div>
    </section>

    <!-- Config List -->
    <main class="px-4 py-2">
        <div class="max-w-lg mx-auto space-y-3" id="configList">
            <!-- Loading Skeleton -->
            <div class="skeleton glass-card rounded-xl p-4 h-32"></div>
            <div class="skeleton glass-card rounded-xl p-4 h-32"></div>
            <div class="skeleton glass-card rounded-xl p-4 h-32"></div>
        </div>
    </main>

    <!-- Subscription Button -->
    <section class="px-4 py-4">
        <div class="max-w-lg mx-auto">
            <a href="api/subscription.php" target="_blank" 
               class="btn-primary block w-full py-4 rounded-xl text-center font-bold text-lg animate-gradient">
                📥 دریافت لینک اشتراک
            </a>
        </div>
    </section>

    <!-- Bottom Navigation -->
    <nav class="bottom-nav glass px-4 py-3">
        <div class="max-w-lg mx-auto flex justify-around">
            <a href="index.php" class="flex flex-col items-center gap-1 text-indigo-400">
                <svg class="w-6 h-6" fill="currentColor" viewBox="0 0 24 24">
                    <path d="M10 20v-6h4v6h5v-8h3L12 3 2 12h3v8z"/>
                </svg>
                <span class="text-xs">خانه</span>
            </a>
            <a href="scanner.php" class="flex flex-col items-center gap-1 text-gray-400 hover:text-white transition">
                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M21 21l-6-6m2-5a7 7 0 11-14 0 7 7 0 0114 0z"/>
                </svg>
                <span class="text-xs">اسکنر</span>
            </a>
            <a href="#" class="flex flex-col items-center gap-1 text-gray-400 hover:text-white transition" onclick="showSubscription()">
                <svg class="w-6 h-6" fill="none" stroke="currentColor" viewBox="0 0 24 24">
                    <path stroke-linecap="round" stroke-linejoin="round" stroke-width="2" d="M4 16v1a3 3 0 003 3h10a3 3 0 003-3v-1m-4-4l-4 4m0 0l-4-4m4 4V4"/>
                </svg>
                <span class="text-xs">اشتراک</span>
            </a>
        </div>
    </nav>

    <!-- Toast -->
    <div id="toast" class="toast glass px-6 py-3 rounded-full text-sm">
        <span id="toastMessage"></span>
    </div>

    <!-- QR Modal -->
    <div id="qrModal" class="fixed inset-0 z-[100] hidden items-center justify-center bg-black/80" onclick="closeQR(event)">
        <div class="glass-card rounded-2xl p-6 max-w-sm mx-4" onclick="event.stopPropagation()">
            <div class="text-center">
                <h3 class="text-lg font-bold mb-4">اسکن QR Code</h3>
                <img id="qrImage" src="" alt="QR Code" class="w-64 h-64 mx-auto bg-white rounded-xl p-2">
                <button onclick="closeQR()" class="mt-4 px-6 py-2 rounded-lg bg-white/10 hover:bg-white/20 transition">
                    بستن
                </button>
            </div>
        </div>
    </div>

    <script src="assets/app.js"></script>
</body>
</html>