<?php
// includes/ConfigCleaner.php

class ConfigCleaner {
    private $db;
    
    public function __construct(Database $db) {
        $this->db = $db;
    }
    
    // حذف تکراری‌ها
    public function removeDuplicates() {
        $pdo = $this->db->getConnection();
        
        // نگه داشتن فقط اولین نسخه از هر کانفیگ تکراری
        $stmt = $pdo->prepare("
            DELETE c1 FROM configs c1
            INNER JOIN configs c2 
            WHERE c1.id > c2.id 
            AND c1.config_hash = c2.config_hash
        ");
        
        return $stmt->execute();
    }
    
    // پاکسازی کانفیگ‌های قدیمی
    public function cleanOldConfigs($days = 7) {
        $pdo = $this->db->getConnection();
        
        $stmt = $pdo->prepare("
            DELETE FROM configs 
            WHERE last_seen < DATE_SUB(NOW(), INTERVAL ? DAY)
            AND score < 3
        ");
        
        return $stmt->execute([$days]);
    }
    
    // تست اتصال کانفیگ (ساده)
    public function testConfig($server, $port, $timeout = 3) {
        $connection = @fsockopen($server, $port, $errno, $errstr, $timeout);
        
        if ($connection) {
            fclose($connection);
            return true;
        }
        
        return false;
    }
    
    // بروزرسانی امتیازات
    public function updateScores() {
        $pdo = $this->db->getConnection();
        
        // افزایش امتیاز برای کانفیگ‌هایی که از چند کانال اومدن
        $pdo->exec("
            UPDATE configs 
            SET score = found_count * 2 
            WHERE found_count > 1
        ");
        
        // کاهش امتیاز کانفیگ‌های قدیمی
        $pdo->exec("
            UPDATE configs 
            SET score = GREATEST(1, score - 1)
            WHERE last_seen < DATE_SUB(NOW(), INTERVAL 3 DAY)
        ");
    }
}