<?php
// api/subscription.php

require_once '../config.php';
require_once '../includes/Database.php';

// تشخیص نوع خروجی
$format = $_GET['format'] ?? 'base64';

try {
    $db = Database::getInstance();
    
    $filters = [
        'protocol' => $_GET['protocol'] ?? null,
        'light_mode' => isset($_GET['light']) && $_GET['light'] === '1',
        'limit' => min((int)($_GET['limit'] ?? 100), 500),
        'offset' => 0
    ];
    
    $configs = $db->getConfigs($filters);
    
    // چک کنیم کانفیگ هست یا نه
    if (empty($configs)) {
        header('Content-Type: text/plain; charset=utf-8');
        echo "# No configs available\n";
        echo "# Please scan some channels first\n";
        echo "# Visit: " . SITE_URL . "/scanner.php\n";
        exit;
    }
    
    // جمع آوری کانفیگ‌ها
    $configLines = [];
    foreach ($configs as $config) {
        if (!empty($config['config_raw'])) {
            $configLines[] = trim($config['config_raw']);
        }
    }
    
    $output = implode("\n", $configLines);
    
    switch ($format) {
        case 'base64':
            header('Content-Type: text/plain; charset=utf-8');
            header('Content-Disposition: inline; filename="subscription.txt"');
            header('Profile-Update-Interval: 6');
            header('Subscription-Userinfo: upload=0; download=0; total=10737418240; expire=0');
            echo base64_encode($output);
            break;
            
        case 'raw':
        case 'txt':
            header('Content-Type: text/plain; charset=utf-8');
            header('Content-Disposition: inline; filename="configs.txt"');
            echo $output;
            break;
            
        case 'json':
            header('Content-Type: application/json; charset=utf-8');
            echo json_encode([
                'success' => true,
                'count' => count($configLines),
                'configs' => $configLines
            ], JSON_UNESCAPED_UNICODE);
            break;
            
        case 'clash':
            header('Content-Type: text/yaml; charset=utf-8');
            echo "# Clash Config\n";
            echo "# Generated: " . date('Y-m-d H:i:s') . "\n";
            echo "# Count: " . count($configLines) . "\n\n";
            echo "proxies:\n";
            // TODO: تبدیل به فرمت Clash
            break;
            
        default:
            header('Content-Type: text/plain; charset=utf-8');
            echo base64_encode($output);
    }
    
} catch (Exception $e) {
    header('Content-Type: text/plain; charset=utf-8');
    http_response_code(500);
    echo "# Error: " . $e->getMessage() . "\n";
}